/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.options;

import com.github.rvesse.airline.help.sections.HelpFormat;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseOptionGroupException;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import com.github.rvesse.airline.utils.predicates.parser.ParsedOptionFinder;
import com.github.rvesse.airline.utils.predicates.restrictions.RequiredFromFinder;
import com.github.rvesse.airline.utils.predicates.restrictions.RequiredTagOptionFinder;
import com.github.rvesse.airline.utils.predicates.restrictions.RequiredTagParsedOptionFinder;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RequireFromRestriction
implements OptionRestriction,
HelpHint {
    private final String tag;
    private final boolean mutuallyExclusive;

    public RequireFromRestriction(String tag, boolean mutuallyExclusive) {
        this.tag = tag;
        this.mutuallyExclusive = mutuallyExclusive;
    }

    @Override
    public <T> void finalValidate(ParseState<T> state, OptionMetadata option) {
        Collection<Pair<OptionMetadata, Object>> parsedOptions = CollectionUtils.select(state.getParsedOptions(), new ParsedOptionFinder(option));
        Collection<OptionRestriction> restrictions = CollectionUtils.select(option.getRestrictions(), new RequiredFromFinder(this.tag));
        for (OptionRestriction restriction : restrictions) {
            Collection<Pair<OptionMetadata, Object>> otherParsedOptions = CollectionUtils.select(state.getParsedOptions(), new RequiredTagParsedOptionFinder(this.tag));
            if (otherParsedOptions.size() > 0 && otherParsedOptions.size() == parsedOptions.size()) continue;
            if (this.mutuallyExclusive && parsedOptions.size() > 0 && otherParsedOptions.size() > parsedOptions.size()) {
                Collection<OptionMetadata> taggedOptions = this.getTaggedOptions(state);
                throw new ParseOptionGroupException("Only one of the following options may be specified but %d were found: %s", this.tag, taggedOptions, otherParsedOptions.size(), RequireFromRestriction.toOptionsList(taggedOptions));
            }
            if (otherParsedOptions.size() != 0) continue;
            Collection<OptionMetadata> taggedOptions = this.getTaggedOptions(state);
            throw new ParseOptionGroupException("%s of the following options must be specified: %s", this.tag, taggedOptions, this.mutuallyExclusive ? "One" : "One/more", RequireFromRestriction.toOptionsList(taggedOptions));
        }
    }

    private static String toOptionsList(Iterable<OptionMetadata> options) {
        StringBuilder builder = new StringBuilder();
        Iterator<OptionMetadata> ops = options.iterator();
        while (ops.hasNext()) {
            OptionMetadata option = ops.next();
            Iterator<String> names = option.getOptions().iterator();
            while (names.hasNext()) {
                builder.append(names.next());
                if (!names.hasNext() && !ops.hasNext()) continue;
                builder.append(", ");
            }
        }
        return builder.toString();
    }

    private <T> Collection<OptionMetadata> getTaggedOptions(ParseState<T> state) {
        List<OptionMetadata> options;
        List<OptionMetadata> list = options = state.getCommand() != null ? state.getCommand().getAllOptions() : null;
        if (options == null) {
            List<OptionMetadata> list2 = options = state.getGroup() != null ? state.getGroup().getOptions() : null;
        }
        if (options == null) {
            options = state.getGlobal() != null ? state.getGlobal().getOptions() : Collections.emptyList();
        }
        return CollectionUtils.select(options, new RequiredTagOptionFinder(this.tag));
    }

    public String getTag() {
        return this.tag;
    }

    @Override
    public String getPreamble() {
        return null;
    }

    @Override
    public HelpFormat getFormat() {
        return HelpFormat.PROSE;
    }

    @Override
    public int numContentBlocks() {
        return 1;
    }

    @Override
    public String[] getContentBlock(int blockNumber) {
        if (blockNumber != 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.mutuallyExclusive) {
            return new String[]{String.format("This option is part of the group '%s' from which only one option may be specified", this.tag)};
        }
        return new String[]{String.format("This option is part of the group '%s' from which at least one option must be specified", this.tag)};
    }

    @Override
    public <T> void preValidate(ParseState<T> state, OptionMetadata option, String value) {
    }

    @Override
    public <T> void postValidate(ParseState<T> state, OptionMetadata option, Object value) {
    }
}

