/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.web.resources;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.schema.GraphQLSchema;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.common.futures.Futures;
import io.stargate.sgv2.common.grpc.StargateBridgeClient;
import io.stargate.sgv2.graphql.persistence.graphqlfirst.SchemaSource;
import io.stargate.sgv2.graphql.persistence.graphqlfirst.SchemaSourceDao;
import io.stargate.sgv2.graphql.schema.CassandraFetcherExceptionHandler;
import io.stargate.sgv2.graphql.schema.cqlfirst.SchemaFactory;
import io.stargate.sgv2.graphql.schema.graphqlfirst.AdminSchemaBuilder;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.CassandraMigrator;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ProcessedSchema;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.SchemaProcessor;
import io.stargate.sgv2.graphql.web.resources.DefaultKeyspaceHelper;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class GraphqlCache {
    private final boolean disableDefaultKeyspace;
    private final GraphQL ddlGraphql;
    private final GraphQL schemaFirstAdminGraphql;
    private volatile CompletionStage<Optional<String>> defaultKeyspaceName;
    private final Cache<String, GraphqlHolder> dmlGraphqlCache = Caffeine.newBuilder().maximumSize(1000L).expireAfterAccess(5L, TimeUnit.MINUTES).build();

    public GraphqlCache(boolean disableDefaultKeyspace) {
        this.disableDefaultKeyspace = disableDefaultKeyspace;
        this.ddlGraphql = GraphqlCache.newGraphql(SchemaFactory.newDdlSchema());
        this.schemaFirstAdminGraphql = GraphqlCache.newGraphql(new AdminSchemaBuilder().build());
    }

    public GraphQL getDdl() {
        return this.ddlGraphql;
    }

    public GraphQL getSchemaFirstAdminGraphql() {
        return this.schemaFirstAdminGraphql;
    }

    public CompletionStage<Optional<GraphQL>> getDmlAsync(StargateBridgeClient bridge, String keyspaceName) {
        String decoratedKeyspaceName = bridge.decorateKeyspaceName(keyspaceName);
        GraphqlHolder holder = this.dmlGraphqlCache.get(decoratedKeyspaceName, __ -> new GraphqlHolder(keyspaceName));
        assert (holder != null);
        return holder.getGraphql(bridge);
    }

    public Optional<GraphQL> getDml(StargateBridgeClient bridge, String keyspaceName) {
        return Futures.getUninterruptibly(this.getDmlAsync(bridge, keyspaceName));
    }

    public void putDml(Schema.CqlKeyspaceDescribe keyspaceDescribe, SchemaSource newSource, GraphQL graphql) {
        Schema.CqlKeyspace keyspace = keyspaceDescribe.getCqlKeyspace();
        GraphqlHolder holder = this.dmlGraphqlCache.get(keyspace.getGlobalName(), __ -> new GraphqlHolder(keyspace.getName()));
        assert (holder != null);
        holder.putGraphql(graphql, keyspaceDescribe.getHash().getValue(), newSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Optional<String>> getDefaultKeyspaceNameAsync(StargateBridgeClient bridge) {
        CompletionStage<Optional<String>> result = this.defaultKeyspaceName;
        if (result != null) {
            return result;
        }
        GraphqlCache graphqlCache = this;
        synchronized (graphqlCache) {
            if (this.defaultKeyspaceName == null) {
                this.defaultKeyspaceName = this.disableDefaultKeyspace ? CompletableFuture.completedFuture(Optional.empty()) : new DefaultKeyspaceHelper(bridge).find();
            }
            return this.defaultKeyspaceName;
        }
    }

    public Optional<String> getDefaultKeyspaceName(StargateBridgeClient bridge) {
        return Futures.getUninterruptibly(this.getDefaultKeyspaceNameAsync(bridge));
    }

    private static GraphQL newGraphql(GraphQLSchema schema) {
        return GraphQL.newGraphQL(schema).defaultDataFetcherExceptionHandler(CassandraFetcherExceptionHandler.INSTANCE).mutationExecutionStrategy(new AsyncExecutionStrategy(CassandraFetcherExceptionHandler.INSTANCE)).build();
    }

    static class GraphqlHolderState {
        final int hash;
        final Optional<SchemaSource> source;
        final CompletableFuture<Optional<GraphQL>> graphqlFuture;

        GraphqlHolderState(int hash, Optional<SchemaSource> source) {
            this.hash = hash;
            this.source = source;
            this.graphqlFuture = new CompletableFuture();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof GraphqlHolderState) {
                GraphqlHolderState that = (GraphqlHolderState)other;
                return this.hash == that.hash && this.source.equals(that.source);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.hash, this.source);
        }
    }

    static class GraphqlHolder {
        private final String keyspaceName;
        private final AtomicReference<GraphqlHolderState> stateRef = new AtomicReference<Object>(null);

        GraphqlHolder(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        CompletionStage<Optional<GraphQL>> getGraphql(StargateBridgeClient bridge) {
            CompletionStage<Optional<Schema.CqlKeyspaceDescribe>> keyspaceFuture = bridge.getKeyspaceAsync(this.keyspaceName, true);
            return keyspaceFuture.thenCompose(maybeKeyspace -> maybeKeyspace.map(keyspace -> this.handleExisting((Schema.CqlKeyspaceDescribe)keyspace, bridge)).orElse(this.handleMissing()));
        }

        private CompletionStage<Optional<GraphQL>> handleMissing() {
            this.stateRef.set(null);
            return CompletableFuture.completedFuture(Optional.empty());
        }

        private CompletionStage<Optional<GraphQL>> handleExisting(Schema.CqlKeyspaceDescribe keyspace, StargateBridgeClient bridge) {
            CompletionStage<Optional<SchemaSource>> sourceFuture = new SchemaSourceDao(bridge).getLatestVersionAsync(this.keyspaceName);
            return sourceFuture.thenCompose(maybeSource -> {
                GraphqlHolderState oldState;
                GraphqlHolderState newState = new GraphqlHolderState(keyspace.getHash().getValue(), (Optional<SchemaSource>)maybeSource);
                if (newState.equals(oldState = this.stateRef.get())) {
                    return oldState.graphqlFuture;
                }
                if (this.stateRef.compareAndSet(oldState, newState)) {
                    this.compute(keyspace, (Optional<SchemaSource>)maybeSource, bridge, newState.graphqlFuture);
                } else {
                    newState = this.stateRef.get();
                }
                return newState.graphqlFuture;
            });
        }

        private void compute(Schema.CqlKeyspaceDescribe keyspace, Optional<SchemaSource> maybeSource, StargateBridgeClient bridge, CompletableFuture<Optional<GraphQL>> toComplete) {
            GraphQL graphql = maybeSource.map(source -> this.computeSchemaFirst(keyspace, bridge, (SchemaSource)source)).orElseGet(() -> this.computeCqlFirst(keyspace));
            toComplete.complete(Optional.of(graphql));
        }

        private GraphQL computeSchemaFirst(Schema.CqlKeyspaceDescribe keyspace, StargateBridgeClient bridge, SchemaSource source) {
            ProcessedSchema processedSchema = new SchemaProcessor(bridge, true).process(source.getContents(), keyspace);
            CassandraMigrator.forPersisted().compute(processedSchema.getMappingModel(), keyspace);
            return processedSchema.getGraphql();
        }

        private GraphQL computeCqlFirst(Schema.CqlKeyspaceDescribe keyspace) {
            return GraphqlCache.newGraphql(SchemaFactory.newDmlSchema(keyspace));
        }

        void putGraphql(GraphQL graphql, int hash, SchemaSource newSource) {
            GraphqlHolderState newState = new GraphqlHolderState(hash, Optional.of(newSource));
            newState.graphqlFuture.complete(Optional.of(graphql));
            this.stateRef.set(newState);
        }
    }
}

