/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class DirectedGraph<VertexT> {
    private final Map<VertexT, Integer> predecessorCounts;
    private final Multimap<VertexT, VertexT> adjacencyList;
    private boolean wasSorted;

    public DirectedGraph(Collection<VertexT> vertices) {
        this.predecessorCounts = Maps.newLinkedHashMapWithExpectedSize(vertices.size());
        this.adjacencyList = LinkedHashMultimap.create();
        for (VertexT vertex : vertices) {
            this.predecessorCounts.put(vertex, 0);
        }
    }

    @SafeVarargs
    @VisibleForTesting
    DirectedGraph(VertexT ... vertices) {
        this((Collection<VertexT>)Arrays.asList(vertices));
    }

    public void addEdge(VertexT from, VertexT to) {
        Preconditions.checkState(!this.wasSorted);
        Preconditions.checkArgument(this.predecessorCounts.containsKey(from) && this.predecessorCounts.containsKey(to));
        this.adjacencyList.put(from, to);
        this.predecessorCounts.put(to, this.predecessorCounts.get(to) + 1);
    }

    public List<VertexT> topologicalSort() {
        Preconditions.checkState(!this.wasSorted);
        this.wasSorted = true;
        ArrayDeque<VertexT> startNodes = new ArrayDeque<VertexT>();
        ArrayList result = Lists.newArrayList();
        for (Map.Entry<VertexT, Integer> entry : this.predecessorCounts.entrySet()) {
            if (entry.getValue() != 0) continue;
            startNodes.add(entry.getKey());
        }
        while (!startNodes.isEmpty()) {
            Object vertex = startNodes.remove();
            result.add(vertex);
            for (VertexT successor : this.adjacencyList.get(vertex)) {
                if (this.decrementAndGetCount(successor) != 0) continue;
                startNodes.add(successor);
            }
        }
        if (result.size() != this.predecessorCounts.size()) {
            throw new IllegalArgumentException("failed to perform topological sort, graph has a cycle");
        }
        return result;
    }

    private int decrementAndGetCount(VertexT vertex) {
        return this.predecessorCounts.compute(vertex, (__, count) -> {
            assert (count != null);
            return count - 1;
        });
    }
}

