/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.processor;

import graphql.language.Directive;
import graphql.language.InputValueDefinition;
import graphql.language.ListType;
import graphql.language.Type;
import io.stargate.sgv2.common.cql.builder.Predicate;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ConditionModelBuilderBase;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.FieldModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.IndexModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.SkipException;
import io.stargate.sgv2.graphql.schema.graphqlfirst.util.TypeHelper;
import java.util.Map;
import java.util.Optional;

class WhereConditionModelBuilder
extends ConditionModelBuilderBase {
    WhereConditionModelBuilder(InputValueDefinition argument, Optional<Directive> directive, EntityModel entity, FieldModel field, String operationName, Map<String, EntityModel> entities, ProcessingContext context) {
        super(argument, directive, entity, field, operationName, entities, context);
    }

    @Override
    protected void validate(FieldModel field, Predicate predicate) throws SkipException {
        if (field.isPartitionKey()) {
            this.checkValidForPartitionKey(predicate, field);
        } else if (field.isClusteringColumn()) {
            this.checkValidForClusteringColumn(predicate, field);
        } else {
            this.checkValidForRegularColumn(predicate, field);
        }
    }

    private void checkValidForPartitionKey(Predicate predicate, FieldModel field) throws SkipException {
        switch (predicate) {
            case EQ: {
                this.checkArgumentIsSameAs(field);
                break;
            }
            case IN: {
                this.checkArgumentIsListOf(field);
                break;
            }
            default: {
                this.invalidMapping("Operation %s: predicate %s is not supported for partition key field %s (expected EQ or IN)", new Object[]{this.operationName, predicate, field.getGraphqlName()});
                throw SkipException.INSTANCE;
            }
        }
    }

    private void checkValidForClusteringColumn(Predicate predicate, FieldModel field) throws SkipException {
        switch (predicate) {
            case EQ: 
            case LT: 
            case GT: 
            case LTE: 
            case GTE: {
                this.checkArgumentIsSameAs(field);
                break;
            }
            case IN: {
                this.checkArgumentIsListOf(field);
                break;
            }
            default: {
                this.invalidMapping("Operation %s: predicate %s is not supported for clustering field %s (expected EQ, LT, GT, LTE, GTE or IN)", new Object[]{this.operationName, predicate, field.getGraphqlName()});
                throw SkipException.INSTANCE;
            }
        }
    }

    private void checkValidForRegularColumn(Predicate predicate, FieldModel field) throws SkipException {
        IndexModel index = field.getIndex().orElseThrow(() -> {
            this.invalidMapping("Operation %s: non-primary key argument %s must be indexed in order to use it in a condition", new Object[]{this.operationName, this.argument.getName()});
            return SkipException.INSTANCE;
        });
        if (index.isBuiltIn()) {
            switch (predicate) {
                case EQ: {
                    this.checkArgumentIsSameAs(field);
                    break;
                }
                case IN: {
                    this.checkArgumentIsListOf(field);
                    break;
                }
                case CONTAINS: {
                    this.checkArgumentIsElementOf(field);
                    break;
                }
                default: {
                    this.invalidMapping("Operation %s: predicate %s is not supported for indexed field %s (expected EQ, IN or CONTAINS)", new Object[]{this.operationName, predicate, field.getGraphqlName()});
                    throw SkipException.INSTANCE;
                }
            }
        }
    }

    private void checkArgumentIsElementOf(FieldModel field) throws SkipException {
        Type<?> argumentType = TypeHelper.unwrapNonNull(this.argument.getType());
        Type<?> fieldInputType = this.fieldInputType();
        if (!(fieldInputType instanceof ListType)) {
            this.invalidMapping("Operation %s: CONTAINS predicate cannot be used with argument %s because it is not a list", new Object[]{this.operationName, this.argument.getName()});
            throw SkipException.INSTANCE;
        }
        Type expectedArgumentType = ((ListType)fieldInputType).getType();
        if (!TypeHelper.deepEquals(argumentType, expectedArgumentType)) {
            this.invalidMapping("Operation %s: expected argument %s to have type %s to match element type of %s.%s", new Object[]{this.operationName, this.argument.getName(), TypeHelper.format(expectedArgumentType), this.entity.getGraphqlName(), field.getGraphqlName()});
        }
    }
}

