/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.processor;

import graphql.language.FieldDefinition;
import graphql.language.ListType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeName;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ModelBuilderBase;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.util.TypeHelper;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;

class ResponsePayloadModelBuilder
extends ModelBuilderBase<ResponsePayloadModel> {
    private final ObjectTypeDefinition type;
    private final String graphqlName;
    private final Map<String, EntityModel> entities;

    ResponsePayloadModelBuilder(ObjectTypeDefinition type, Map<String, EntityModel> entities, ProcessingContext context) {
        super(context, type.getSourceLocation());
        this.type = type;
        this.graphqlName = type.getName();
        this.entities = entities;
    }

    @Override
    ResponsePayloadModel build() {
        ResponsePayloadModel.EntityField entityField = null;
        EnumSet<ResponsePayloadModel.TechnicalField> technicalFields = EnumSet.noneOf(ResponsePayloadModel.TechnicalField.class);
        for (FieldDefinition field : this.type.getFieldDefinitions()) {
            ResponsePayloadModel.EntityField newEntityField = this.asEntityField(field);
            if (newEntityField != null) {
                if (entityField == null) {
                    entityField = newEntityField;
                    continue;
                }
                this.invalidMapping("%s: both %s and %s reference a mapped entity. There can only be one such field.", this.graphqlName, entityField.getName(), newEntityField.getName());
                continue;
            }
            ResponsePayloadModel.TechnicalField technicalField = ResponsePayloadModel.TechnicalField.matching(field);
            if (technicalField != null) {
                technicalFields.add(technicalField);
                continue;
            }
            this.invalidMapping("%s: couldn't map field %s. It doesn't match any of the predefined technical fields, nor does it reference a mapped entity.", this.graphqlName, field.getName());
        }
        return new ResponsePayloadModel(Optional.ofNullable(entityField), technicalFields);
    }

    private ResponsePayloadModel.EntityField asEntityField(FieldDefinition field) {
        Type<?> type = TypeHelper.unwrapNonNull(field.getType());
        boolean isList = type instanceof ListType;
        if (isList) {
            type = TypeHelper.unwrapNonNull(((ListType)type).getType());
        }
        assert (type instanceof TypeName);
        EntityModel entity = this.entities.get(((TypeName)type).getName());
        return entity == null ? null : new ResponsePayloadModel.EntityField(field.getName(), entity, isList);
    }
}

