/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.processor;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import graphql.ErrorClassification;
import graphql.GraphQLError;
import graphql.language.SourceLocation;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ProcessingErrorType;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ProcessingLogType;
import java.util.Collections;
import java.util.List;

public class ProcessingMessage<TypeT extends ErrorClassification>
implements GraphQLError {
    private final String message;
    private final SourceLocation location;
    private final TypeT errorType;

    @FormatMethod
    public static ProcessingMessage<ProcessingLogType> log(SourceLocation location, ProcessingLogType type, @FormatString String format, Object ... arguments) {
        return new ProcessingMessage<ProcessingLogType>(location, type, String.format(format, arguments));
    }

    @FormatMethod
    public static ProcessingMessage<ProcessingErrorType> error(SourceLocation location, ProcessingErrorType type, @FormatString String format, Object ... arguments) {
        return new ProcessingMessage<ProcessingErrorType>(location, type, String.format(format, arguments));
    }

    private ProcessingMessage(SourceLocation location, TypeT errorType, String message) {
        this.errorType = errorType;
        this.message = message;
        this.location = location;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public List<SourceLocation> getLocations() {
        return this.location == null ? Collections.emptyList() : Collections.singletonList(this.location);
    }

    public TypeT getErrorType() {
        return this.errorType;
    }

    public String toString() {
        return "ProcessingMessage{message='" + this.message + '\'' + ", location=" + this.location + ", errorType=" + this.errorType + '}';
    }
}

