/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.processor;

import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.ListType;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.schema.GraphQLScalarType;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ConditionModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.DirectiveHelper;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ModelBuilderBase;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.OperationModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.SkipException;
import io.stargate.sgv2.graphql.schema.graphqlfirst.util.TypeHelper;
import io.stargate.sgv2.graphql.schema.scalars.CqlScalar;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

abstract class OperationModelBuilderBase<T extends OperationModel>
extends ModelBuilderBase<T> {
    protected final FieldDefinition operation;
    protected final String operationName;
    protected final Map<String, EntityModel> entities;
    protected final Map<String, ResponsePayloadModel> responsePayloads;

    protected OperationModelBuilderBase(FieldDefinition operation, Map<String, EntityModel> entities, Map<String, ResponsePayloadModel> responsePayloads, ProcessingContext context) {
        super(context, operation.getSourceLocation());
        this.operation = operation;
        this.operationName = operation.getName();
        this.entities = entities;
        this.responsePayloads = responsePayloads;
    }

    OperationModel.ReturnType getReturnType(String operationDescription) throws SkipException {
        Type<?> graphqlType = TypeHelper.unwrapNonNull(this.operation.getType());
        if (graphqlType instanceof ListType) {
            OperationModel.ReturnType listReturnType = this.toListReturnType((ListType)graphqlType);
            if (listReturnType != null) {
                return listReturnType;
            }
        } else {
            assert (graphqlType instanceof TypeName);
            String typeName = ((TypeName)graphqlType).getName();
            OperationModel.SimpleReturnType simple = OperationModel.SimpleReturnType.fromTypeName(typeName);
            if (simple != null) {
                return simple;
            }
            EntityModel entity = this.entities.get(typeName);
            if (entity != null) {
                return new OperationModel.EntityReturnType(entity);
            }
            ResponsePayloadModel payload = this.responsePayloads.get(typeName);
            if (payload != null) {
                return payload;
            }
        }
        this.invalidMapping("%s: unsupported return type %s", operationDescription, TypeHelper.format(graphqlType));
        throw SkipException.INSTANCE;
    }

    private OperationModel.ReturnType toListReturnType(ListType graphqlType) {
        Type<?> elementType = graphqlType.getType();
        if ((elementType = TypeHelper.unwrapNonNull(elementType)) instanceof TypeName) {
            String typeName = ((TypeName)elementType).getName();
            EntityModel entity = this.entities.get(typeName);
            if (entity != null) {
                return new OperationModel.EntityListReturnType(entity);
            }
            ResponsePayloadModel payload = this.responsePayloads.get(typeName);
            if (payload != null) {
                return new OperationModel.ResponsePayloadModelListReturnType(payload);
            }
            OperationModel.SimpleReturnType simple = OperationModel.SimpleReturnType.fromTypeName(typeName);
            if (simple != null) {
                return new OperationModel.SimpleListReturnType(simple);
            }
        }
        return null;
    }

    protected void validateNoFiltering(List<ConditionModel> whereConditions, EntityModel entity) throws SkipException {
        Optional<String> maybeError = entity.validateNoFiltering(whereConditions);
        if (maybeError.isPresent()) {
            this.invalidMapping("Operation %s: %s", this.operationName, maybeError.get());
            throw SkipException.INSTANCE;
        }
    }

    protected Optional<String> findFieldNameWithDirective(String directiveName, GraphQLScalarType ... expectedTypes) throws SkipException {
        Optional<String> result = Optional.empty();
        for (InputValueDefinition inputValue : this.operation.getInputValueDefinitions()) {
            if (!this.hasDirectiveAndType(inputValue, directiveName, expectedTypes)) continue;
            if (result.isPresent()) {
                this.invalidMapping("Query %s: @%s can be used on at most one argument (found %s and %s)", this.operationName, directiveName, result.get(), inputValue.getName());
                throw SkipException.INSTANCE;
            }
            result = Optional.of(inputValue.getName());
        }
        return result;
    }

    private boolean hasDirectiveAndType(InputValueDefinition inputValue, String directiveName, GraphQLScalarType ... expectedTypes) throws SkipException {
        boolean hasDirective = DirectiveHelper.getDirective(directiveName, inputValue).isPresent();
        if (!hasDirective) {
            return false;
        }
        Type<?> type = TypeHelper.unwrapNonNull(inputValue.getType());
        for (GraphQLScalarType expectedType : expectedTypes) {
            String name = expectedType.getName();
            if (!(type instanceof TypeName) || !((TypeName)type).getName().equals(name)) continue;
            CqlScalar.fromGraphqlName(name).ifPresent(this.context.getUsedCqlScalars()::add);
            return true;
        }
        this.handleTypeMismatch(inputValue, directiveName, expectedTypes);
        return false;
    }

    private void handleTypeMismatch(InputValueDefinition inputValue, String directiveName, GraphQLScalarType ... expectedTypes) throws SkipException {
        if (expectedTypes.length == 1) {
            this.invalidMapping("Query %s: argument %s annotated with @%s must have type %s", this.operationName, inputValue.getName(), directiveName, expectedTypes[0].getName());
        } else {
            this.invalidMapping("Query %s: argument %s annotated with @%s must have one of the types %s", this.operationName, inputValue.getName(), directiveName, this.mapToNames(expectedTypes));
        }
        throw SkipException.INSTANCE;
    }

    private List<String> mapToNames(GraphQLScalarType ... expectedTypes) {
        return Arrays.stream(expectedTypes).map(GraphQLScalarType::getName).collect(Collectors.toList());
    }
}

