/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.processor;

import graphql.language.Directive;
import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.ListType;
import graphql.language.Type;
import graphql.language.TypeName;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.DirectiveHelper;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.MutationModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.OperationModelBuilderBase;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.SkipException;
import io.stargate.sgv2.graphql.schema.graphqlfirst.util.TypeHelper;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.Map;
import java.util.Optional;

abstract class MutationModelBuilder
extends OperationModelBuilderBase<MutationModel> {
    protected MutationModelBuilder(FieldDefinition operation, Map<String, EntityModel> entities, Map<String, ResponsePayloadModel> responsePayloads, ProcessingContext context) {
        super(operation, entities, responsePayloads, context);
    }

    protected Optional<EntityModel> findEntity(InputValueDefinition input) {
        String inputTypeName;
        Type<?> type = TypeHelper.unwrapNonNull(input.getType());
        if (type instanceof ListType) {
            Type<?> innerListType = TypeHelper.unwrapNonNull(((ListType)type).getType());
            inputTypeName = ((TypeName)innerListType).getName();
        } else {
            inputTypeName = ((TypeName)type).getName();
        }
        return this.entities.values().stream().filter(e -> e.getInputTypeName().map(name -> name.equals(inputTypeName)).orElse(false)).findFirst();
    }

    protected boolean isList(InputValueDefinition input) {
        Type<?> type = TypeHelper.unwrapNonNull(input.getType());
        return type instanceof ListType;
    }

    protected EntityModel entityFromDirective(Optional<Directive> cqlDeleteDirective, String name, String directive) throws SkipException {
        String entityName = (String)cqlDeleteDirective.flatMap(d -> DirectiveHelper.getStringArgument(d, "targetEntity", this.context)).orElseThrow(() -> {
            this.invalidMapping("Mutation %s: if a %s doesn't take an entity input type, it must indicate the entity name in '@%s.%s'", this.operationName, name, directive, "targetEntity");
            return SkipException.INSTANCE;
        });
        EntityModel entity = (EntityModel)this.entities.get(entityName);
        if (entity == null) {
            this.invalidMapping("Mutation %s: unknown entity %s (from '@%s.%s')", this.operationName, entityName, directive, "targetEntity");
            throw SkipException.INSTANCE;
        }
        return entity;
    }

    protected boolean computeIfExists(Optional<Directive> directive) {
        return directive.flatMap(d -> DirectiveHelper.getBooleanArgument(d, "ifExists", this.context)).orElseGet(() -> {
            if (this.operation.getName().endsWith("IfExists")) {
                this.info("Mutation %s: setting the '%s' flag implicitly because the name follows the naming convention.", this.operationName, "ifExists");
                return true;
            }
            return false;
        });
    }

    protected Optional<QueryOuterClass.Consistency> getConsistencyLevel(Optional<Directive> directive) {
        return directive.flatMap(d -> DirectiveHelper.getEnumArgument(d, "consistencyLevel", QueryOuterClass.Consistency.class, this.context));
    }

    protected Optional<QueryOuterClass.Consistency> getSerialConsistencyLevel(Optional<Directive> directive) {
        return directive.flatMap(d -> DirectiveHelper.getEnumArgument(d, "serialConsistency", QueryOuterClass.Consistency.class, this.context));
    }

    protected Optional<Integer> getTtl(Optional<Directive> directive) {
        return directive.flatMap(d -> DirectiveHelper.getStringArgument(d, "ttl", this.context).flatMap(this::parseTtl));
    }

    private Optional<Integer> parseTtl(String spec) {
        long seconds;
        try {
            seconds = Long.parseLong(spec);
        }
        catch (NumberFormatException e) {
            try {
                Duration duration = Duration.parse(spec);
                seconds = duration.getSeconds();
                if (duration.getNano() != 0) {
                    this.warn("Mutation %s: TTL's minimum granularity is seconds, the nanosecond part will be ignored", this.operationName);
                }
            }
            catch (DateTimeParseException e2) {
                this.invalidMapping("Mutation %s: can't parse TTL '%s' (expected an integer or ISO-8601 duration string)", this.operationName, spec);
                return Optional.empty();
            }
        }
        if (seconds < 0L || seconds > Integer.MAX_VALUE) {
            this.invalidMapping("Mutation %s: TTL must between 0 and 2^31 - 1 seconds", this.operationName);
            return Optional.empty();
        }
        return Optional.of((int)seconds);
    }
}

