/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.processor;

import graphql.Scalars;
import graphql.language.Directive;
import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.DirectiveHelper;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.InsertModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.MutationModelBuilder;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.OperationModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.SkipException;
import io.stargate.sgv2.graphql.schema.scalars.CqlScalar;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class InsertModelBuilder
extends MutationModelBuilder {
    private final String parentTypeName;

    InsertModelBuilder(FieldDefinition mutation, String parentTypeName, Map<String, EntityModel> entities, Map<String, ResponsePayloadModel> responsePayloads, ProcessingContext context) {
        super(mutation, entities, responsePayloads, context);
        this.parentTypeName = parentTypeName;
    }

    @Override
    InsertModel build() throws SkipException {
        Optional<Directive> cqlInsertDirective = DirectiveHelper.getDirective("cql_insert", this.operation);
        boolean ifNotExists = this.computeIfNotExists(cqlInsertDirective);
        List<InputValueDefinition> inputs = this.operation.getInputValueDefinitions();
        if (inputs.isEmpty()) {
            this.invalidMapping("Mutation %s: inserts must take the entity input type as the first argument", this.operationName);
            throw SkipException.INSTANCE;
        }
        if (inputs.size() > 2) {
            this.invalidMapping("Mutation %s: inserts can't have more than two arguments: entity input and optionally a value with %s directive", this.operationName, "cql_timestamp");
            throw SkipException.INSTANCE;
        }
        InputValueDefinition input = inputs.get(0);
        EntityModel entity = this.findEntity(input).orElseThrow(() -> {
            this.invalidMapping("Mutation %s: unexpected argument type, inserts expect an input object that maps to a CQL entity", this.operationName);
            return SkipException.INSTANCE;
        });
        boolean isList = this.isList(input);
        OperationModel.ReturnType returnType = this.getReturnType("Mutation " + this.operationName);
        if (!returnType.getEntity().filter(e -> e.equals(entity)).isPresent() && returnType != OperationModel.SimpleReturnType.BOOLEAN && !this.isSimpleListWithBoolean(returnType)) {
            this.invalidMapping("Mutation %s: invalid return type. Expected %s, or a response payload that wraps a single instance of it or Boolean, or a list of those types.", this.operationName, entity.getGraphqlName());
        }
        if (isList && !returnType.isList()) {
            this.invalidMapping("Mutation %s: invalid return type. For bulk inserts, expected list of %s. ", this.operationName, entity.getGraphqlName());
        }
        Optional<String> cqlTimestampArgumentName = this.findFieldNameWithDirective("cql_timestamp", Scalars.GraphQLString, CqlScalar.BIGINT.getGraphqlType());
        if (inputs.size() == 2 && !cqlTimestampArgumentName.isPresent()) {
            this.invalidMapping("Mutation %s: if you provided two arguments, the second one must be annotated with %s directive.", this.operationName, "cql_timestamp");
        }
        Optional<ResponsePayloadModel> responsePayload = Optional.of(returnType).map(r -> {
            if (r instanceof OperationModel.ResponsePayloadModelListReturnType) {
                return ((OperationModel.ResponsePayloadModelListReturnType)returnType).getResponsePayloadModel();
            }
            return r;
        }).filter(ResponsePayloadModel.class::isInstance).map(ResponsePayloadModel.class::cast);
        return new InsertModel(this.parentTypeName, this.operation, entity, input.getName(), responsePayload, ifNotExists, this.getConsistencyLevel(cqlInsertDirective), this.getSerialConsistencyLevel(cqlInsertDirective), this.getTtl(cqlInsertDirective), returnType, cqlTimestampArgumentName, isList, this.context.getKeyspace());
    }

    private boolean isSimpleListWithBoolean(OperationModel.ReturnType returnType) {
        return returnType instanceof OperationModel.SimpleListReturnType && ((OperationModel.SimpleListReturnType)returnType).getSimpleReturnType().equals(OperationModel.SimpleReturnType.BOOLEAN);
    }

    private boolean computeIfNotExists(Optional<Directive> cqlInsertDirective) {
        Optional fromDirective = cqlInsertDirective.flatMap(d -> DirectiveHelper.getBooleanArgument(d, "ifNotExists", this.context));
        if (fromDirective.isPresent()) {
            return (Boolean)fromDirective.get();
        }
        if (this.operation.getName().endsWith("IfNotExists")) {
            this.info("Mutation %s: setting the '%s' flag implicitly because the name follows the naming convention.", this.operationName, "ifNotExists");
            return true;
        }
        return false;
    }
}

