/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.processor;

import com.google.common.collect.ImmutableMap;
import graphql.Scalars;
import graphql.language.Directive;
import graphql.language.EnumTypeDefinition;
import graphql.language.FieldDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.idl.TypeDefinitionRegistry;
import io.stargate.bridge.grpc.TypeSpecs;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.DirectiveHelper;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.FieldModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.IndexModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.IndexModelBuilder;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ModelBuilderBase;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.SkipException;
import io.stargate.sgv2.graphql.schema.scalars.CqlScalar;
import java.util.Map;
import java.util.Optional;

class FieldModelBuilder
extends ModelBuilderBase<FieldModel> {
    private static final Map<String, QueryOuterClass.TypeSpec> GRAPHQL_SCALAR_MAPPINGS = ImmutableMap.builder().put(Scalars.GraphQLInt.getName(), TypeSpecs.INT).put(Scalars.GraphQLFloat.getName(), TypeSpecs.DOUBLE).put(Scalars.GraphQLString.getName(), TypeSpecs.VARCHAR).put(Scalars.GraphQLBoolean.getName(), TypeSpecs.BOOLEAN).put(Scalars.GraphQLID.getName(), TypeSpecs.UUID).build();
    private final FieldDefinition field;
    private final String parentCqlName;
    private final EntityModel.Target targetContainer;
    private final boolean checkForInputType;
    private final String graphqlName;
    private final Type<?> graphqlType;
    private final String messagePrefix;
    private final Optional<Directive> cqlColumnDirective;

    FieldModelBuilder(FieldDefinition field, ProcessingContext context, String parentCqlName, String parentGraphqlName, EntityModel.Target targetContainer, boolean checkForInputType) {
        super(context, field.getSourceLocation());
        this.field = field;
        this.parentCqlName = parentCqlName;
        this.targetContainer = targetContainer;
        this.checkForInputType = checkForInputType;
        this.graphqlName = field.getName();
        this.graphqlType = field.getType();
        this.messagePrefix = parentGraphqlName + "." + this.graphqlName;
        this.cqlColumnDirective = DirectiveHelper.getDirective("cql_column", field);
    }

    @Override
    FieldModel build() throws SkipException {
        String cqlName = this.cqlColumnDirective.flatMap(d -> DirectiveHelper.getStringArgument(d, "name", this.context)).orElse(this.graphqlName);
        boolean isUdtField = this.targetContainer == EntityModel.Target.UDT;
        boolean partitionKey = this.isPartitionKey(isUdtField);
        Optional<Schema.ColumnOrderBy> clusteringOrder = this.getClusteringOrder(isUdtField);
        if (partitionKey && clusteringOrder.isPresent()) {
            this.invalidMapping("%s: can't be both a partition key and a clustering key.", this.messagePrefix);
            throw SkipException.INSTANCE;
        }
        boolean isPk = partitionKey || clusteringOrder.isPresent();
        QueryOuterClass.TypeSpec cqlType = this.inferCqlType(this.graphqlType, true, this.context);
        if (isPk || cqlType.hasUdt() && isUdtField) {
            cqlType = TypeSpecs.freeze(cqlType);
        }
        cqlType = this.maybeUseTypeHint(cqlType, isPk, isUdtField);
        return new FieldModel(this.graphqlName, this.graphqlType, cqlName, cqlType, partitionKey, clusteringOrder, this.getIndex(cqlName, isUdtField, isPk, cqlType));
    }

    private Boolean isPartitionKey(boolean isUdtField) {
        return this.cqlColumnDirective.flatMap(d -> DirectiveHelper.getBooleanArgument(d, "partitionKey", this.context)).filter(__ -> {
            if (isUdtField) {
                this.warn("%s: UDT fields should not be marked as partition keys (this will be ignored)", this.messagePrefix);
                return false;
            }
            return true;
        }).orElse(false);
    }

    private Optional<Schema.ColumnOrderBy> getClusteringOrder(boolean isUdtField) {
        return this.cqlColumnDirective.flatMap(d -> DirectiveHelper.getEnumArgument(d, "clusteringOrder", Schema.ColumnOrderBy.class, this.context)).filter(__ -> {
            if (isUdtField) {
                this.warn("%s: UDT fields should not be marked as clustering keys (this will be ignored)", this.messagePrefix);
                return false;
            }
            return true;
        });
    }

    private QueryOuterClass.TypeSpec inferCqlType(Type<?> graphqlType, boolean isRoot, ProcessingContext context) throws SkipException {
        if (graphqlType instanceof NonNullType) {
            return this.inferCqlType(((NonNullType)graphqlType).getType(), isRoot, context);
        }
        if (graphqlType instanceof ListType) {
            return QueryOuterClass.TypeSpec.newBuilder().setList(QueryOuterClass.TypeSpec.List.newBuilder().setElement(this.inferCqlType(((ListType)graphqlType).getType(), false, context)).setFrozen(!isRoot)).build();
        }
        String typeName = ((TypeName)graphqlType).getName();
        TypeDefinitionRegistry typeRegistry = context.getTypeRegistry();
        if (GRAPHQL_SCALAR_MAPPINGS.containsKey(typeName)) {
            return GRAPHQL_SCALAR_MAPPINGS.get(typeName);
        }
        if (typeRegistry.types().containsKey(typeName)) {
            TypeDefinition definition = typeRegistry.getType(typeName).orElseThrow(AssertionError::new);
            if (definition instanceof EnumTypeDefinition) {
                return TypeSpecs.VARCHAR;
            }
            if (definition instanceof ObjectTypeDefinition) {
                return this.expectUdt((ObjectTypeDefinition)definition, isRoot);
            }
            this.invalidMapping("%s: can't map type '%s' to CQL", this.messagePrefix, graphqlType);
            throw SkipException.INSTANCE;
        }
        Optional<CqlScalar> maybeCqlScalar = CqlScalar.fromGraphqlName(typeName);
        if (maybeCqlScalar.isPresent()) {
            CqlScalar cqlScalar = maybeCqlScalar.get();
            context.getUsedCqlScalars().add(cqlScalar);
            return cqlScalar.getCqlType();
        }
        this.invalidMapping("%s: can't map type '%s' to CQL", this.messagePrefix, graphqlType);
        throw SkipException.INSTANCE;
    }

    private QueryOuterClass.TypeSpec expectUdt(ObjectTypeDefinition definition, boolean isRoot) throws SkipException {
        boolean isUdt = DirectiveHelper.getDirective("cql_entity", definition).flatMap(d -> DirectiveHelper.getEnumArgument(d, "target", EntityModel.Target.class, this.context)).filter(target -> target == EntityModel.Target.UDT).isPresent();
        if (isUdt) {
            if (this.checkForInputType && !DirectiveHelper.getDirective("cql_input", definition).isPresent()) {
                this.invalidMapping("%s: type '%s' must also be annotated with @%s", this.messagePrefix, definition.getName(), "cql_input");
                throw SkipException.INSTANCE;
            }
            return QueryOuterClass.TypeSpec.newBuilder().setUdt(QueryOuterClass.TypeSpec.Udt.newBuilder().setName(definition.getName()).setFrozen(!isRoot)).build();
        }
        this.invalidMapping("%s: can't map type '%s' to CQL -- if a field references an object type, then that object should map to a UDT", this.messagePrefix, definition.getName());
        throw SkipException.INSTANCE;
    }

    private QueryOuterClass.TypeSpec maybeUseTypeHint(QueryOuterClass.TypeSpec cqlType, boolean isPk, boolean isUdtField) throws SkipException {
        QueryOuterClass.TypeSpec cqlTypeHint;
        Optional maybeCqlTypeHint = this.cqlColumnDirective.flatMap(d -> DirectiveHelper.getStringArgument(d, "typeHint", this.context));
        if (!maybeCqlTypeHint.isPresent()) {
            return cqlType;
        }
        String spec = (String)maybeCqlTypeHint.get();
        try {
            cqlTypeHint = TypeSpecs.parse(spec, this.context.getKeyspace().getTypesList(), false);
        }
        catch (IllegalArgumentException e) {
            this.invalidSyntax("%s: could not parse CQL type '%s': %s", this.messagePrefix, spec, e.getMessage());
            throw SkipException.INSTANCE;
        }
        if (isPk && (TypeSpecs.isCollection(cqlTypeHint) || cqlTypeHint.hasUdt()) && !TypeSpecs.isFrozen(cqlTypeHint)) {
            this.invalidMapping("%s: invalid type hint '%s' -- partition or clustering columns must be frozen", this.messagePrefix, spec);
            throw SkipException.INSTANCE;
        }
        if (cqlTypeHint.hasUdt() && isUdtField && !TypeSpecs.isFrozen(cqlTypeHint)) {
            this.invalidMapping("%s: invalid type hint '%s' -- nested UDTs must be frozen", this.messagePrefix, spec);
            throw SkipException.INSTANCE;
        }
        if (!FieldModelBuilder.isCompatible(cqlTypeHint, cqlType)) {
            this.invalidMapping("%s: invalid type hint '%s'-- the inferred type was '%s', you can only change frozenness or use sets instead of lists", this.messagePrefix, TypeSpecs.format(cqlTypeHint), TypeSpecs.format(cqlType));
            throw SkipException.INSTANCE;
        }
        return cqlTypeHint;
    }

    private static boolean isCompatible(QueryOuterClass.TypeSpec type1, QueryOuterClass.TypeSpec type2) {
        QueryOuterClass.TypeSpec.SpecCase spec2;
        QueryOuterClass.TypeSpec.SpecCase spec1 = type1.getSpecCase();
        if (!(spec1 == (spec2 = type2.getSpecCase()) || spec1 == QueryOuterClass.TypeSpec.SpecCase.LIST && spec2 == QueryOuterClass.TypeSpec.SpecCase.SET || spec1 == QueryOuterClass.TypeSpec.SpecCase.SET && spec2 == QueryOuterClass.TypeSpec.SpecCase.LIST)) {
            return false;
        }
        switch (spec1) {
            case UDT: {
                return type1.getUdt().getName().equals(type2.getUdt().getName());
            }
            case LIST: 
            case SET: {
                QueryOuterClass.TypeSpec element1 = spec1 == QueryOuterClass.TypeSpec.SpecCase.LIST ? type1.getList().getElement() : type1.getSet().getElement();
                QueryOuterClass.TypeSpec element2 = spec2 == QueryOuterClass.TypeSpec.SpecCase.LIST ? type2.getList().getElement() : type2.getSet().getElement();
                return FieldModelBuilder.isCompatible(element1, element2);
            }
            case MAP: {
                QueryOuterClass.TypeSpec.Map map1 = type1.getMap();
                QueryOuterClass.TypeSpec.Map map2 = type2.getMap();
                return FieldModelBuilder.isCompatible(map1.getKey(), map2.getKey()) && FieldModelBuilder.isCompatible(map1.getValue(), map2.getValue());
            }
            case TUPLE: {
                QueryOuterClass.TypeSpec.Tuple tuple1 = type1.getTuple();
                QueryOuterClass.TypeSpec.Tuple tuple2 = type2.getTuple();
                if (tuple1.getElementsCount() != tuple2.getElementsCount()) {
                    return false;
                }
                for (int i = 0; i < tuple1.getElementsCount(); ++i) {
                    if (FieldModelBuilder.isCompatible(tuple1.getElements(i), tuple2.getElements(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    private Optional<IndexModel> getIndex(String cqlName, boolean isUdtField, boolean isPk, QueryOuterClass.TypeSpec cqlType) throws SkipException {
        Optional<Directive> cqlIndexDirective = DirectiveHelper.getDirective("cql_index", this.field);
        if (cqlIndexDirective.isPresent()) {
            if (isPk) {
                this.invalidMapping("%s: partition or clustering columns can't have an index", this.messagePrefix);
                throw SkipException.INSTANCE;
            }
            if (isUdtField) {
                this.invalidMapping("%s: UDT fields can't have an index", this.messagePrefix);
                throw SkipException.INSTANCE;
            }
            return Optional.of(new IndexModelBuilder(cqlIndexDirective.get(), this.parentCqlName, cqlName, cqlType, this.messagePrefix, this.context).build());
        }
        return Optional.empty();
    }
}

