/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.deployed;

import com.google.common.collect.Lists;
import graphql.ExceptionWhileDataFetching;
import graphql.GraphQLException;
import graphql.execution.DataFetcherResult;
import graphql.language.OperationDefinition;
import graphql.language.SourceLocation;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.common.cql.builder.BuiltCondition;
import io.stargate.sgv2.common.cql.builder.Literal;
import io.stargate.sgv2.common.cql.builder.Predicate;
import io.stargate.sgv2.common.futures.Futures;
import io.stargate.sgv2.common.grpc.proto.Rows;
import io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.deployed.DeployedFetcher;
import io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.deployed.MutationPayload;
import io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.deployed.MutationResult;
import io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.deployed.TypedKeyValue;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.FieldModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.MappingModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.MutationModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.OperationModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.sgv2.graphql.web.resources.StargateGraphqlContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class MutationFetcher<MutationModelT extends MutationModel, ResultT>
extends DeployedFetcher<CompletionStage<ResultT>> {
    protected final MutationModelT model;

    protected MutationFetcher(MutationModelT model, MappingModel mappingModel, Schema.CqlKeyspaceDescribe keyspace) {
        super(mappingModel, keyspace);
        this.model = model;
    }

    protected abstract MutationPayload<ResultT> getPayload(DataFetchingEnvironment var1, StargateGraphqlContext var2);

    @Override
    protected CompletionStage<ResultT> get(DataFetchingEnvironment environment, StargateGraphqlContext context) {
        MutationPayload<ResultT> payload = null;
        Exception buildException = null;
        try {
            payload = this.getPayload(environment, context);
        }
        catch (Exception e) {
            buildException = e;
        }
        if (this.isAtomic(environment, payload)) {
            return this.executeAsPartOfBatch(payload, buildException, environment, context);
        }
        return this.executeAsIndividualQueries(payload, buildException, context);
    }

    private CompletableFuture<ResultT> executeAsPartOfBatch(MutationPayload<ResultT> payload, Exception buildException, DataFetchingEnvironment environment, StargateGraphqlContext context) {
        int totalSelections;
        StargateGraphqlContext.BatchContext batchContext = context.getBatchContext();
        for (QueryOuterClass.Query query : payload.getQueries()) {
            if (!query.hasParameters() || batchContext.setParameters(query.getParameters())) continue;
            buildException = new GraphQLException("all the selections in an @atomic mutation must use the same consistency levels");
            break;
        }
        if (buildException != null) {
            batchContext.setExecutionResult(new GraphQLException("@atomic mutation aborted because one of the operations failed (see other errors for details)"));
            return Futures.failedFuture(buildException);
        }
        int currentSelections = batchContext.add(payload.getQueries());
        if (currentSelections == (totalSelections = environment.getOperationDefinition().getSelectionSet().getSelections().size()) && !batchContext.getExecutionFuture().isDone()) {
            batchContext.setExecutionResult(context.getBridge().executeBatchAsync(QueryOuterClass.Batch.newBuilder().addAllQueries(batchContext.getQueries()).setParameters(batchContext.getParameters()).build()));
        }
        return batchContext.getExecutionFuture().thenApply(response -> payload.getResultBuilder().apply(this.buildBatchResults(response.getResultSet(), payload)));
    }

    private List<MutationResult> buildBatchResults(QueryOuterClass.ResultSet resultSet, MutationPayload<ResultT> payload) {
        List<List<TypedKeyValue>> primaryKeys = payload.getPrimaryKeys();
        ArrayList<MutationResult> results = Lists.newArrayListWithCapacity(primaryKeys.size());
        if (this.isApplied(resultSet)) {
            for (int i = 0; i < primaryKeys.size(); ++i) {
                results.add(MutationResult.Applied.INSTANCE);
            }
        } else {
            for (List<TypedKeyValue> primaryKey : primaryKeys) {
                Optional<QueryOuterClass.Row> row = resultSet.getRowsList().stream().filter(r -> this.matches((QueryOuterClass.Row)r, resultSet.getColumnsList(), primaryKey)).findFirst();
                MutationResult.NotApplied result = new MutationResult.NotApplied(row, resultSet.getColumnsList());
                results.add(result);
            }
        }
        return results;
    }

    private boolean matches(QueryOuterClass.Row row, List<QueryOuterClass.ColumnSpec> columns, List<TypedKeyValue> primaryKey) {
        for (TypedKeyValue kv : primaryKey) {
            if (!columns.stream().noneMatch(c -> kv.getName().equals(c.getName()) && kv.getType().equals(c.getType())) && kv.getValue().equals(Rows.getValue(row, kv.getName(), columns))) continue;
            return false;
        }
        return true;
    }

    private CompletionStage<ResultT> executeAsIndividualQueries(MutationPayload<ResultT> payload, Exception buildException, StargateGraphqlContext context) {
        if (buildException != null) {
            return Futures.failedFuture(buildException);
        }
        List results = payload.getQueries().stream().map(query -> context.getBridge().executeQueryAsync((QueryOuterClass.Query)query).thenApply(MutationResult::forSingleQuery).exceptionally(MutationResult.Failure::new)).collect(Collectors.toList());
        return Futures.sequence(results).thenApply(payload.getResultBuilder());
    }

    private boolean isAtomic(DataFetchingEnvironment environment, MutationPayload<ResultT> payload) {
        OperationDefinition operation = environment.getOperationDefinition();
        return operation.getDirectives().stream().anyMatch(d -> d.getName().equals("atomic")) && (operation.getSelectionSet().getSelections().size() > 1 || payload.getQueries().size() > 1);
    }

    protected QueryOuterClass.QueryParameters buildParameters() {
        QueryOuterClass.ConsistencyValue consistencyLevel = ((MutationModel)this.model).getConsistencyLevel().map(c -> QueryOuterClass.ConsistencyValue.newBuilder().setValue((QueryOuterClass.Consistency)c).build()).orElse(DEFAULT_CONSISTENCY);
        QueryOuterClass.ConsistencyValue serialConsistencyLevel = ((MutationModel)this.model).getSerialConsistencyLevel().map(c -> QueryOuterClass.ConsistencyValue.newBuilder().setValue((QueryOuterClass.Consistency)c).build()).orElse(DEFAULT_SERIAL_CONSISTENCY);
        if (consistencyLevel == DEFAULT_CONSISTENCY && serialConsistencyLevel == DEFAULT_SERIAL_CONSISTENCY) {
            return DEFAULT_PARAMETERS;
        }
        return DEFAULT_PARAMETERS.toBuilder().setConsistency(consistencyLevel).setSerialConsistency(serialConsistencyLevel).build();
    }

    protected ExceptionWhileDataFetching toGraphqlError(MutationResult.Failure failure, SourceLocation location, DataFetchingEnvironment environment) {
        return this.toGraphqlError(failure.getError(), location, environment);
    }

    protected ExceptionWhileDataFetching toGraphqlError(Throwable error, SourceLocation location, DataFetchingEnvironment environment) {
        return new ExceptionWhileDataFetching(environment.getExecutionStepInfo().getPath(), error, location);
    }

    protected SourceLocation getCurrentFieldLocation(DataFetchingEnvironment environment) {
        return environment.getMergedField().getSingleField().getSourceLocation();
    }

    protected Function<List<MutationResult>, DataFetcherResult<Object>> getDeleteOrUpdateResultBuilder(DataFetchingEnvironment environment) {
        return queryResults -> {
            DataFetcherResult.Builder<Serializable> result = DataFetcherResult.newResult();
            assert (queryResults.size() == 1);
            MutationResult queryResult = (MutationResult)queryResults.get(0);
            if (queryResult instanceof MutationResult.Failure) {
                result.error(this.toGraphqlError((MutationResult.Failure)queryResult, this.getCurrentFieldLocation(environment), environment));
            } else {
                boolean applied = queryResult instanceof MutationResult.Applied;
                OperationModel.ReturnType returnType = ((MutationModel)this.model).getReturnType();
                if (returnType == OperationModel.SimpleReturnType.BOOLEAN) {
                    result.data(Boolean.valueOf(applied));
                } else {
                    ResponsePayloadModel payload = (ResponsePayloadModel)returnType;
                    LinkedHashMap<String, Serializable> data = new LinkedHashMap<String, Serializable>();
                    if (payload.getTechnicalFields().contains((Object)ResponsePayloadModel.TechnicalField.APPLIED)) {
                        data.put(ResponsePayloadModel.TechnicalField.APPLIED.getGraphqlName(), Boolean.valueOf(applied));
                    }
                    if (payload.getEntityField().isPresent()) {
                        LinkedHashMap entityData = new LinkedHashMap();
                        if (queryResult instanceof MutationResult.NotApplied) {
                            MutationResult.NotApplied notApplied = (MutationResult.NotApplied)queryResult;
                            notApplied.getRow().ifPresent(row -> this.copyRowToEntity((QueryOuterClass.Row)row, notApplied.getColumns(), entityData, ((MutationModel)this.model).getEntity()));
                        }
                        data.put(payload.getEntityField().get().getName(), entityData);
                    }
                    result.data(data);
                }
            }
            return result.build();
        };
    }

    protected List<TypedKeyValue> computePrimaryKey(EntityModel entity, List<BuiltCondition> whereConditions) {
        ArrayList<TypedKeyValue> result = new ArrayList<TypedKeyValue>();
        for (FieldModel field : entity.getPrimaryKey()) {
            whereConditions.stream().filter(c -> field.getCqlName().equals(c.lhs().columnName()) && !c.lhs().value().isPresent() && c.predicate() == Predicate.EQ).map(c -> ((Literal)c.value()).get()).findFirst().ifPresent(v -> result.add(new TypedKeyValue(field.getCqlName(), field.getCqlType(), (QueryOuterClass.Value)v)));
        }
        return result;
    }
}

