/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.admin;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.graphql.persistence.graphqlfirst.SchemaSourceDao;
import io.stargate.sgv2.graphql.schema.CassandraFetcher;
import io.stargate.sgv2.graphql.web.resources.StargateGraphqlContext;
import java.util.UUID;

public class UndeploySchemaFetcher
extends CassandraFetcher<Boolean> {
    @Override
    protected Boolean get(DataFetchingEnvironment environment, StargateGraphqlContext context) throws Exception {
        String keyspaceName = (String)environment.getArgument("keyspace");
        Schema.CqlKeyspaceDescribe keyspace = context.getBridge().getKeyspace(keyspaceName, true).orElseThrow(() -> new IllegalArgumentException("Keyspace '%s' does not exist."));
        UUID expectedVersion = this.getExpectedVersion(environment);
        boolean force = (Boolean)environment.getArgument("force");
        new SchemaSourceDao(context.getBridge()).undeploy(keyspaceName, expectedVersion, force);
        return true;
    }

    private UUID getExpectedVersion(DataFetchingEnvironment environment) {
        try {
            return UUID.fromString((String)environment.getArgument("expectedVersion"));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid 'expectedVersion' value.");
        }
    }
}

