/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.admin;

import com.google.common.annotations.VisibleForTesting;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.sgv2.common.grpc.StargateBridgeClient;
import io.stargate.sgv2.graphql.persistence.graphqlfirst.SchemaSource;
import io.stargate.sgv2.graphql.persistence.graphqlfirst.SchemaSourceDao;
import io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.admin.SchemaFetcher;
import io.stargate.sgv2.graphql.web.resources.StargateGraphqlContext;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;

public class SingleSchemaFetcher
extends SchemaFetcher<SchemaSource> {
    private final Function<StargateBridgeClient, SchemaSourceDao> schemaSourceDaoProvider;

    public SingleSchemaFetcher() {
        this(SchemaSourceDao::new);
    }

    @VisibleForTesting
    public SingleSchemaFetcher(Function<StargateBridgeClient, SchemaSourceDao> schemaSourceDaoProvider) {
        this.schemaSourceDaoProvider = schemaSourceDaoProvider;
    }

    @Override
    public SchemaSource get(DataFetchingEnvironment environment, StargateGraphqlContext context) throws Exception {
        StargateBridgeClient bridge = context.getBridge();
        String keyspace = this.getKeyspace(environment, bridge);
        Optional<UUID> version = Optional.ofNullable((String)environment.getArgument("version")).map(UUID::fromString);
        return this.schemaSourceDaoProvider.apply(bridge).getSingleVersion(keyspace, version).orElse(null);
    }
}

