/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.admin;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.graphql.persistence.graphqlfirst.SchemaSource;
import io.stargate.sgv2.graphql.persistence.graphqlfirst.SchemaSourceDao;
import io.stargate.sgv2.graphql.schema.CassandraFetcher;
import io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.admin.DeploySchemaResponseDto;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.CassandraMigrator;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.MigrationQuery;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.MigrationStrategy;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ProcessedSchema;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.SchemaProcessor;
import io.stargate.sgv2.graphql.web.resources.StargateGraphqlContext;
import java.io.IOException;
import java.util.List;
import java.util.UUID;

abstract class DeploySchemaFetcherBase
extends CassandraFetcher<DeploySchemaResponseDto> {
    DeploySchemaFetcherBase() {
    }

    @Override
    protected DeploySchemaResponseDto get(DataFetchingEnvironment environment, StargateGraphqlContext context) throws Exception {
        List<MigrationQuery> queries;
        ProcessedSchema processedSchema;
        SchemaSourceDao schemaSourceDao = new SchemaSourceDao(context.getBridge());
        String keyspaceName = (String)environment.getArgument("keyspace");
        Schema.CqlKeyspaceDescribe keyspace = context.getBridge().getKeyspace(keyspaceName, true).orElseThrow(() -> new IllegalArgumentException("Keyspace '%s' does not exist."));
        String input = this.getSchemaContents(environment);
        UUID expectedVersion = this.getExpectedVersion(environment);
        MigrationStrategy migrationStrategy = (MigrationStrategy)((Object)environment.getArgument("migrationStrategy"));
        boolean force = (Boolean)environment.getArgument("force");
        boolean dryRun = (Boolean)environment.getArgument("dryRun");
        if (!dryRun) {
            schemaSourceDao.startDeployment(keyspaceName, expectedVersion, force);
        }
        DeploySchemaResponseDto response = new DeploySchemaResponseDto();
        try {
            processedSchema = new SchemaProcessor(context.getBridge(), false).process(input, keyspace);
            response.setLogs(processedSchema.getLogs());
            queries = CassandraMigrator.forDeployment(migrationStrategy).compute(processedSchema.getMappingModel(), keyspace);
            response.setCqlChanges(queries);
        }
        catch (Exception e) {
            if (!dryRun) {
                schemaSourceDao.abortDeployment(keyspaceName);
            }
            throw e;
        }
        if (!dryRun) {
            for (MigrationQuery query : queries) {
                context.getBridge().executeQuery(query.build());
            }
            SchemaSource newSource = schemaSourceDao.insert(keyspaceName, input);
            schemaSourceDao.purgeOldVersions(keyspaceName);
            response.setVersion(newSource.getVersion());
            keyspace = context.getBridge().getKeyspace(keyspaceName, false).orElseThrow(() -> new IllegalArgumentException("Keyspace '%s' does not exist."));
            context.getGraphqlCache().putDml(keyspace, newSource, processedSchema.getGraphql());
        }
        return response;
    }

    protected abstract String getSchemaContents(DataFetchingEnvironment var1) throws IOException;

    private UUID getExpectedVersion(DataFetchingEnvironment environment) {
        UUID expectedVersion;
        String expectedVersionSpec = (String)environment.getArgument("expectedVersion");
        try {
            expectedVersion = expectedVersionSpec == null ? null : UUID.fromString(expectedVersionSpec);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid 'expectedVersion' value.");
        }
        return expectedVersion;
    }
}

