/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.cqlfirst.dml;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.NameConversions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameMapping {
    private static final Logger LOG = LoggerFactory.getLogger(NameMapping.class);
    private final BiMap<String, String> entityNames = HashBiMap.create();
    private final Map<String, BiMap<String, String>> columnNames;
    private final BiMap<String, String> udtNames = HashBiMap.create();
    private final Map<String, BiMap<String, String>> fieldNames;
    private final List<String> warnings;

    public NameMapping(List<Schema.CqlTable> tables, List<QueryOuterClass.TypeSpec.Udt> udts, List<String> warnings) {
        this.warnings = warnings;
        this.columnNames = new HashMap<String, BiMap<String, String>>();
        this.buildTableNames(tables);
        this.fieldNames = new HashMap<String, BiMap<String, String>>();
        this.buildUdtNames(udts);
    }

    private void buildTableNames(List<Schema.CqlTable> tables) {
        for (Schema.CqlTable table : tables) {
            String cqlName = table.getName();
            String graphqlName = NameConversions.toGraphql(cqlName, NameConversions.IdentifierType.TABLE);
            String clashingCqlName = (String)this.entityNames.inverse().get(graphqlName);
            if (clashingCqlName != null) {
                String message = String.format("Couldn't convert table %s because its GraphQL name %s would collide with table %s", cqlName, graphqlName, clashingCqlName);
                this.warnings.add(message);
                LOG.warn(message);
                continue;
            }
            if (!graphqlName.equals(cqlName)) {
                this.warnings.add(String.format("Table %s mapped as %s", cqlName, graphqlName));
            }
            this.entityNames.put(cqlName, graphqlName);
            this.columnNames.put(cqlName, this.buildColumnNames(table));
        }
    }

    private void buildUdtNames(List<QueryOuterClass.TypeSpec.Udt> udts) {
        for (QueryOuterClass.TypeSpec.Udt udt : udts) {
            String cqlName = udt.getName();
            String graphqlName = NameConversions.toGraphql(cqlName, NameConversions.IdentifierType.UDT);
            String clashingCqlName = (String)this.udtNames.inverse().get(graphqlName);
            if (clashingCqlName != null) {
                String message = String.format("Could not convert UDT %s because its GraphQL name %s would collide with UDT %s", cqlName, graphqlName, clashingCqlName);
                this.warnings.add(message);
                LOG.warn(message);
                continue;
            }
            if (!graphqlName.equals(cqlName + "Udt")) {
                this.warnings.add(String.format("UDT %s mapped as %s", cqlName, graphqlName));
            }
            this.udtNames.put(cqlName, graphqlName);
            this.fieldNames.put(cqlName, this.buildFieldNames(udt));
        }
    }

    private BiMap<String, String> buildColumnNames(Schema.CqlTable table) {
        String tableName = table.getName();
        HashBiMap<String, String> map = HashBiMap.create();
        this.buildColumnNames(table.getPartitionKeyColumnsList().stream().map(QueryOuterClass.ColumnSpec::getName), map, tableName);
        this.buildColumnNames(table.getClusteringKeyColumnsList().stream().map(QueryOuterClass.ColumnSpec::getName), map, tableName);
        this.buildColumnNames(table.getColumnsList().stream().map(QueryOuterClass.ColumnSpec::getName), map, tableName);
        this.buildColumnNames(table.getStaticColumnsList().stream().map(QueryOuterClass.ColumnSpec::getName), map, tableName);
        return map;
    }

    private BiMap<String, String> buildFieldNames(QueryOuterClass.TypeSpec.Udt udt) {
        String udtName = udt.getName();
        HashBiMap<String, String> map = HashBiMap.create();
        this.buildColumnNames(udt.getFieldsMap().keySet().stream(), map, udtName);
        return map;
    }

    private void buildColumnNames(Stream<String> columnNames, BiMap<String, String> map, String tableName) {
        columnNames.forEach(columnName -> {
            String graphqlName = NameConversions.toGraphql(columnName, NameConversions.IdentifierType.COLUMN);
            String clashingCqlName = (String)map.inverse().get(graphqlName);
            if (clashingCqlName != null) {
                String message = String.format("Could not convert column %s in table/UDT %s because its GraphQL name %s would collide with column %s", columnName, tableName, graphqlName, clashingCqlName);
                this.warnings.add(message);
                LOG.warn(message);
            } else {
                if (!graphqlName.equals(columnName)) {
                    this.warnings.add(String.format("Column %s in table/UDT %s mapped as %s", columnName, tableName, graphqlName));
                }
                map.put((String)columnName, graphqlName);
            }
        });
    }

    public String getGraphqlName(Schema.CqlTable table) {
        return (String)this.entityNames.get(table.getName());
    }

    public String getGraphqlName(Schema.CqlTable table, QueryOuterClass.ColumnSpec column) {
        return (String)this.columnNames.get(table.getName()).get(column.getName());
    }

    public String getCqlName(Schema.CqlTable table, String graphqlName) {
        return (String)this.columnNames.get(table.getName()).inverse().get(graphqlName);
    }

    public String getGraphqlName(QueryOuterClass.TypeSpec.Udt udt) {
        return (String)this.udtNames.get(udt.getName());
    }

    public String getGraphqlName(QueryOuterClass.TypeSpec.Udt udt, String fieldName) {
        return (String)this.fieldNames.get(udt.getName()).get(fieldName);
    }

    public String getCqlName(QueryOuterClass.TypeSpec.Udt udt, String graphqlName) {
        return (String)this.fieldNames.get(udt.getName()).inverse().get(graphqlName);
    }
}

