/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.cqlfirst.dml;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class NameConversions {
    private static final ImmutableMap<String, String> RESERVED_GRAPHQL_NAMES = ImmutableMap.builder().put("Mutation", "Mutatiox6e_").put("MutationConsistency", "MutationConsistencx79_").put("MutationOptions", "MutationOptionx73_").put("Query", "Querx79_").put("QueryConsistency", "QueryConsistencx79_").put("QueryOptions", "QueryOptionx73_").put("SerialConsistency", "SerialConsistencx79_").put("Boolean", "Booleax6e_").put("Float", "Floax74_").put("Int", "Inx74_").put("String", "Strinx67_").put("Uuid", "Uuix64_").put("TimeUuid", "TimeUuix64_").put("Inet", "Inex74_").put("Date", "Datx65_").put("Duration", "Duratiox6e_").put("BigInt", "BigInx74_").put("Counter", "Countex72_").put("Ascii", "Ascix69_").put("Decimal", "Decimax6c_").put("Varint", "Varinx74_").put("Float32", "Float32").put("Blob", "Blox62_").put("SmallInt", "SmallInx74_").put("TinyInt", "TinyInx74_").put("Timestamp", "Timestamx70_").put("Time", "Timx65_").put("conversionWarnings", "conversionWarningx73_").build();
    private static final ImmutableMap<String, String> RESERVED_PREFIXES = ImmutableMap.builder().put("Entry", "Entrx79_").put("Tuple", "Tuplx65_").build();
    private static final ImmutableMap<String, String> RESERVED_SUFFIXES = ImmutableMap.builder().put("Input", "Inpux74_").put("Result", "Resulx74_").put("Order", "Ordex72_").put("Udt", "Udx74_").build();

    private NameConversions() {
    }

    public static String toGraphql(String cqlName, IdentifierType type) {
        String graphqlName;
        if (cqlName == null || cqlName.isEmpty()) {
            throw new IllegalArgumentException("CQL name must be non-null and not empty");
        }
        if (type == IdentifierType.TABLE && (graphqlName = RESERVED_GRAPHQL_NAMES.get(cqlName)) != null) {
            return graphqlName;
        }
        graphqlName = NameConversions.maybeHexEscape(cqlName);
        if (type == IdentifierType.TABLE) {
            graphqlName = NameConversions.escapeReservedPrefix(graphqlName);
            graphqlName = NameConversions.escapeReservedSuffix(graphqlName);
        } else if (type == IdentifierType.UDT) {
            graphqlName = NameConversions.escapeReservedPrefix(graphqlName);
            graphqlName = graphqlName + "Udt";
        }
        return graphqlName;
    }

    public static String toCql(String graphqlName, IdentifierType type) {
        if (graphqlName == null || graphqlName.isEmpty()) {
            throw new IllegalArgumentException("GraphQL name must be non-null and not empty");
        }
        if (type == IdentifierType.UDT && graphqlName.endsWith("Udt")) {
            graphqlName = graphqlName.substring(0, graphqlName.length() - 3);
        }
        return NameConversions.maybeHexUnescape(graphqlName);
    }

    private static String maybeHexEscape(String source) {
        return NameConversions.needsHexEscape(source) ? NameConversions.hexEscape(source) : source;
    }

    private static boolean needsHexEscape(String source) {
        int charCount;
        assert (source != null && !source.isEmpty());
        if (source.startsWith("__") || NameConversions.isDigit(source.charAt(0))) {
            return true;
        }
        int length = source.length();
        for (int i = 0; i < length; i += charCount) {
            int cp = source.codePointAt(i);
            charCount = Character.charCount(cp);
            if (charCount <= 1 && NameConversions.isValidGraphql(cp) && (cp != 120 || NameConversions.lengthOfHexEscape(source, i) <= 0)) continue;
            return true;
        }
        return false;
    }

    private static String hexEscape(String source) {
        int cp;
        assert (source != null && !source.isEmpty());
        StringBuilder result = new StringBuilder();
        int i = 0;
        int length = source.length();
        if (source.startsWith("__")) {
            result.append("x5f__");
            i = 2;
        } else {
            cp = source.charAt(0);
            if (NameConversions.isDigit(cp)) {
                NameConversions.appendHexEscape(result, cp);
                i = 1;
            }
        }
        while (i < length) {
            cp = source.codePointAt(i);
            int charCount = Character.charCount(cp);
            if (charCount > 1 || !NameConversions.isValidGraphql(cp) || cp == 120 && NameConversions.lengthOfHexEscape(source, i) > 0) {
                NameConversions.appendHexEscape(result, cp);
            } else {
                result.append((char)cp);
            }
            i += charCount;
        }
        return result.toString();
    }

    private static String maybeHexUnescape(String source) {
        return NameConversions.needsHexUnescape(source) ? NameConversions.hexUnescape(source) : source;
    }

    private static boolean needsHexUnescape(String source) {
        assert (source != null && !source.isEmpty());
        int length = source.length();
        for (int i = 0; i < length; ++i) {
            if (source.charAt(i) != 'x' || NameConversions.lengthOfHexEscape(source, i) <= 0) continue;
            return true;
        }
        return false;
    }

    private static String hexUnescape(String source) {
        assert (source != null && !source.isEmpty());
        StringBuilder result = new StringBuilder();
        int i = 0;
        int length = source.length();
        while (i < length) {
            int l;
            char c = source.charAt(i);
            if (c == 'x' && (l = NameConversions.lengthOfHexEscape(source, i)) > 0) {
                String hexString = source.substring(i + 1, i + l - 1);
                result.appendCodePoint(Integer.parseInt(hexString, 16));
                i += l;
                continue;
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    private static int lengthOfHexEscape(String name, int i) {
        assert (name.charAt(i) == 'x');
        for (int j = i + 1; j < name.length(); ++j) {
            char c = name.charAt(j);
            if (c == '_') {
                return j == i + 1 ? -1 : j - i + 1;
            }
            if (NameConversions.isHex(c)) continue;
            return -1;
        }
        return -1;
    }

    private static void appendHexEscape(StringBuilder target, int codePoint) {
        target.append('x').append(Integer.toHexString(codePoint)).append('_');
    }

    private static boolean isValidGraphql(int c) {
        return NameConversions.isDigit(c) || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95;
    }

    private static boolean isHex(int c) {
        return NameConversions.isDigit(c) || c >= 97 && c <= 102;
    }

    private static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private static String escapeReservedPrefix(String result) {
        for (Map.Entry entry : RESERVED_PREFIXES.entrySet()) {
            String prefix = (String)entry.getKey();
            String replacement = (String)entry.getValue();
            if (!result.startsWith(prefix)) continue;
            return replacement + result.substring(prefix.length());
        }
        return result;
    }

    private static String escapeReservedSuffix(String result) {
        for (Map.Entry entry : RESERVED_SUFFIXES.entrySet()) {
            String suffix = (String)entry.getKey();
            String replacement = (String)entry.getValue();
            if (!result.endsWith(suffix)) continue;
            return result.substring(0, result.length() - suffix.length()) + replacement;
        }
        return result;
    }

    static enum IdentifierType {
        TABLE,
        UDT,
        COLUMN;

    }
}

