/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.cqlfirst.dml;

import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.FieldTypeCache;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.NameMapping;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.SchemaWarningException;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.types.MapBuilder;
import io.stargate.sgv2.graphql.schema.cqlfirst.dml.types.TupleBuilder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class FieldOutputTypeCache
extends FieldTypeCache<GraphQLOutputType> {
    private final List<String> warnings;

    FieldOutputTypeCache(NameMapping nameMapping, List<String> warnings) {
        super(nameMapping);
        this.warnings = warnings;
    }

    @Override
    protected GraphQLOutputType compute(QueryOuterClass.TypeSpec columnType) {
        switch (columnType.getSpecCase()) {
            case MAP: {
                QueryOuterClass.TypeSpec.Map map = columnType.getMap();
                return new MapBuilder((GraphQLType)this.get(map.getKey()), (GraphQLType)this.get(map.getValue()), false).build();
            }
            case LIST: {
                return new GraphQLList((GraphQLType)this.get(columnType.getList().getElement()));
            }
            case SET: {
                return new GraphQLList((GraphQLType)this.get(columnType.getSet().getElement()));
            }
            case UDT: {
                return this.computeUdt(columnType.getUdt());
            }
            case TUPLE: {
                List<GraphQLType> subTypes = columnType.getTuple().getElementsList().stream().map(this::get).collect(Collectors.toList());
                return new TupleBuilder(subTypes).buildOutputType();
            }
            case BASIC: {
                return this.getScalar(columnType.getBasic());
            }
        }
        throw new IllegalArgumentException("Unsupported type " + columnType);
    }

    private GraphQLOutputType computeUdt(QueryOuterClass.TypeSpec.Udt udt) {
        String graphqlName = this.nameMapping.getGraphqlName(udt);
        if (graphqlName == null) {
            throw new SchemaWarningException(String.format("Could not find a GraphQL name mapping for UDT %s, this is probably because it clashes with another UDT", udt.getName()));
        }
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name(graphqlName);
        for (Map.Entry<String, QueryOuterClass.TypeSpec> entry : udt.getFieldsMap().entrySet()) {
            String cqlFieldName = entry.getKey();
            QueryOuterClass.TypeSpec fieldType = entry.getValue();
            String graphqlFieldName = this.nameMapping.getGraphqlName(udt, cqlFieldName);
            if (graphqlFieldName == null) continue;
            try {
                builder.field(new GraphQLFieldDefinition.Builder().name(graphqlFieldName).type((GraphQLOutputType)this.get(fieldType)).build());
            }
            catch (Exception e) {
                this.warnings.add(String.format("Could not create output type for field %s in UDT %s, skipping (%s)", cqlFieldName, udt.getName(), e.getMessage()));
            }
        }
        return builder.build();
    }
}

