/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.metrics.jersey.sgv2;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.jersey2.server.JerseyTagsProvider;
import java.util.Objects;
import java.util.Optional;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.monitoring.RequestEvent;

public class TenantIdFromHostHeaderTagsProvider
implements JerseyTagsProvider {
    private static final String DEFAULT_TENANT_TAG_KEY = "tenant";
    private final String tenantTagName;
    private final Tags tagsForUnknown;

    public TenantIdFromHostHeaderTagsProvider() {
        this(DEFAULT_TENANT_TAG_KEY);
    }

    public TenantIdFromHostHeaderTagsProvider(String tenantTagName) {
        this.tenantTagName = Objects.requireNonNull(tenantTagName);
        this.tagsForUnknown = Tags.of(tenantTagName, "unknown");
    }

    @Override
    public Iterable<Tag> httpRequestTags(RequestEvent event) {
        return this.extractTenantFromHost(event);
    }

    @Override
    public Iterable<Tag> httpLongRequestTags(RequestEvent event) {
        return this.extractTenantFromHost(event);
    }

    protected Iterable<Tag> extractTenantFromHost(RequestEvent event) {
        ContainerRequest request = event.getContainerRequest();
        MultivaluedMap<String, String> headers = request.getHeaders();
        String value = headers.getFirst("Host");
        if (value == null) {
            value = headers.getFirst("host");
        }
        return this.extractTenantId(value).map(t -> Tags.of(this.tenantTagName, t)).orElse(this.tagsForUnknown);
    }

    protected Optional<String> extractTenantId(String host) {
        if (host == null || host.length() < 36) {
            return Optional.empty();
        }
        return Optional.of(host.substring(0, 36));
    }
}

