/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.core.metrics.impl;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import java.util.Arrays;
import java.util.stream.DoubleStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MeterRegistryConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MeterRegistryConfiguration.class);
    private static final String HTTP_PERCENTILES_PROPERTY = "stargate.metrics.http_server_requests_percentiles";

    private MeterRegistryConfiguration() {
    }

    public static void configure(MeterRegistry registry) {
        MeterRegistryConfiguration.configureHttpPercentiles(registry.config());
    }

    public static void configure(MeterRegistry.Config config) {
        MeterRegistryConfiguration.configureHttpPercentiles(config);
    }

    private static void configureHttpPercentiles(MeterRegistry.Config config) {
        double[] finalPercentiles;
        String percentiles = System.getProperty(HTTP_PERCENTILES_PROPERTY);
        if (null != percentiles && (finalPercentiles = Arrays.stream(percentiles.split(",")).map(String::trim).flatMapToDouble(p -> {
            try {
                double percentile = Double.parseDouble(p);
                if (Double.isFinite(percentile) && percentile >= 0.0 && percentile <= 1.0) {
                    return DoubleStream.of(percentile);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            logger.warn("Value \"{}\" can not be used as the percentile for the {}, was expecting a double [0, 1].", p, (Object)HTTP_PERCENTILES_PROPERTY);
            return DoubleStream.empty();
        }).toArray()).length > 0) {
            config.meterFilter(new PercentilesMeterFilter(finalPercentiles, "http.server.requests"));
        }
    }

    private static class PercentilesMeterFilter
    implements MeterFilter {
        private final double[] percentiles;
        private final String metricName;

        public PercentilesMeterFilter(double[] percentiles, String metricName) {
            this.percentiles = percentiles;
            this.metricName = metricName;
        }

        @Override
        public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig config) {
            if (id.getName().startsWith(this.metricName)) {
                return DistributionStatisticConfig.builder().percentiles(this.percentiles).build().merge(config);
            }
            return config;
        }
    }
}

