/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.validation;

import io.dropwizard.util.Size;
import io.dropwizard.util.SizeUnit;
import io.dropwizard.validation.MaxSize;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class MaxSizeValidator
implements ConstraintValidator<MaxSize, Size> {
    private long maxQty = 0L;
    private SizeUnit maxUnit = SizeUnit.BYTES;

    @Override
    public void initialize(MaxSize constraintAnnotation) {
        this.maxQty = constraintAnnotation.value();
        this.maxUnit = constraintAnnotation.unit();
    }

    @Override
    public boolean isValid(Size value, ConstraintValidatorContext context) {
        return value == null || value.toBytes() <= this.maxUnit.toBytes(this.maxQty);
    }
}

