/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipException;
import org.eclipse.jetty.http.BadMessageException;

class ZipExceptionHandlingInputStream
extends InputStream {
    private final InputStream delegate;
    private final String format;

    ZipExceptionHandlingInputStream(InputStream in, String format) {
        this.delegate = in;
        this.format = format;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return this.delegate.read(b, off, len);
        }
        catch (IOException e) {
            throw ZipExceptionHandlingInputStream.handleException(this.format, e);
        }
    }

    @Override
    public int read() throws IOException {
        try {
            return this.delegate.read();
        }
        catch (IOException e) {
            throw ZipExceptionHandlingInputStream.handleException(this.format, e);
        }
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            return this.delegate.skip(n);
        }
        catch (IOException e) {
            throw ZipExceptionHandlingInputStream.handleException(this.format, e);
        }
    }

    @Override
    public int available() throws IOException {
        try {
            return this.delegate.available();
        }
        catch (IOException e) {
            throw ZipExceptionHandlingInputStream.handleException(this.format, e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            throw ZipExceptionHandlingInputStream.handleException(this.format, e);
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        try {
            this.delegate.reset();
        }
        catch (IOException e) {
            throw ZipExceptionHandlingInputStream.handleException(this.format, e);
        }
    }

    static BadMessageException handleException(String format, IOException e) throws IOException {
        if (e instanceof ZipException) {
            return ZipExceptionHandlingInputStream.buildBadDataException(format, e);
        }
        if (e instanceof EOFException) {
            return ZipExceptionHandlingInputStream.buildPrematureEofException(format, e);
        }
        throw e;
    }

    private static BadMessageException buildBadDataException(String format, Throwable cause) {
        return new BadMessageException(400, "Invalid " + format + " data in request", cause);
    }

    private static BadMessageException buildPrematureEofException(String format, Throwable cause) {
        return new BadMessageException(400, "Premature end of " + format + " data", cause);
    }
}

