/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation.threadpools;

import com.google.common.annotations.Beta;
import graphql.Assert;
import graphql.Internal;
import graphql.TrivialDataFetcher;
import graphql.execution.Async;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Internal
@Beta
public class ExecutorInstrumentation
extends SimpleInstrumentation {
    private static final Consumer<Action> NOOP = a -> {};
    private final Executor fetchExecutor;
    private final Executor processingExecutor;
    private final Consumer<Action> actionObserver;

    private ExecutorInstrumentation(Executor fetchExecutor, Executor processingExecutor, Consumer<Action> actionObserver) {
        this.fetchExecutor = fetchExecutor;
        this.processingExecutor = processingExecutor;
        this.actionObserver = actionObserver;
    }

    public Executor getFetchExecutor() {
        return this.fetchExecutor;
    }

    public Executor getProcessingExecutor() {
        return this.processingExecutor;
    }

    public static Builder newThreadPoolExecutionInstrumentation() {
        return new Builder();
    }

    @Override
    public DataFetcher<?> instrumentDataFetcher(DataFetcher<?> originalDataFetcher, InstrumentationFieldFetchParameters parameters) {
        if (originalDataFetcher instanceof TrivialDataFetcher) {
            return originalDataFetcher;
        }
        return environment -> {
            CompletionStage<CompletionStage<Object>> invokedCF = this.fetchExecutor != null ? CompletableFuture.supplyAsync(this.invokedAsync(originalDataFetcher, environment), this.fetchExecutor) : this.invokedSynch(originalDataFetcher, environment);
            invokedCF = this.processingExecutor != null ? invokedCF.thenApplyAsync(this.processingControl(), this.processingExecutor) : invokedCF.thenApply(this.processingControl());
            return invokedCF.thenCompose(cs -> cs);
        };
    }

    private Supplier<CompletionStage<?>> invokedAsync(DataFetcher<?> originalDataFetcher, DataFetchingEnvironment environment) {
        return () -> {
            this.actionObserver.accept(Action.FETCHING);
            return this.invokeOriginalDF(originalDataFetcher, environment);
        };
    }

    private CompletableFuture<CompletionStage<?>> invokedSynch(DataFetcher<?> originalDataFetcher, DataFetchingEnvironment environment) {
        this.actionObserver.accept(Action.FETCHING);
        return CompletableFuture.completedFuture(this.invokeOriginalDF(originalDataFetcher, environment));
    }

    private Function<CompletionStage<?>, CompletionStage<?>> processingControl() {
        return completionStage -> {
            this.actionObserver.accept(Action.PROCESSING);
            return completionStage;
        };
    }

    private CompletionStage<?> invokeOriginalDF(DataFetcher<?> originalDataFetcher, DataFetchingEnvironment environment) {
        Object value;
        try {
            value = originalDataFetcher.get(environment);
        }
        catch (Exception e) {
            return Async.exceptionallyCompletedFuture(e);
        }
        if (value instanceof CompletionStage) {
            return (CompletionStage)value;
        }
        return CompletableFuture.completedFuture(value);
    }

    public static class Builder {
        Executor fetchExecutor;
        Executor processingExecutor;
        private Consumer<Action> actionObserver;

        public Builder fetchExecutor(Executor fetchExecutor) {
            this.fetchExecutor = fetchExecutor;
            return this;
        }

        public Builder processingExecutor(Executor processingExecutor) {
            this.processingExecutor = processingExecutor;
            return this;
        }

        public Builder actionObserver(Consumer<Action> actionObserver) {
            this.actionObserver = Assert.assertNotNull(actionObserver);
            return this;
        }

        public ExecutorInstrumentation build() {
            return new ExecutorInstrumentation(this.fetchExecutor, this.processingExecutor, this.actionObserver != null ? this.actionObserver : NOOP);
        }
    }

    static enum Action {
        FETCHING,
        PROCESSING;

    }
}

