/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.types.numerics.abbreviated;

import com.github.rvesse.airline.types.numerics.abbreviated.MapAbbreviatedNumericTypeConverter;
import java.util.HashMap;
import java.util.Map;

public class SequenceAbbreviatedNumericTypeConverter
extends MapAbbreviatedNumericTypeConverter {
    public SequenceAbbreviatedNumericTypeConverter(boolean caseSensitive, Map<String, Integer> prefixes, long multiplierBase, String ... suffixes) {
        super(caseSensitive, prefixes, SequenceAbbreviatedNumericTypeConverter.buildSuffixes(multiplierBase, suffixes));
    }

    protected static Map<String, Long> buildSuffixes(long base, String ... suffixes) {
        if (base <= 0L) {
            throw new IllegalArgumentException("Base multiplier must be >= 1");
        }
        HashMap<String, Long> suffixMap = new HashMap<String, Long>();
        long m3 = base;
        for (String s2 : suffixes) {
            suffixMap.put(s2, m3);
            long nextM = m3 * base;
            if (nextM < m3) {
                throw new IllegalArgumentException("Too many suffixes leading to numeric overflow");
            }
            m3 = nextM;
        }
        return suffixMap;
    }
}

