/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.common;

import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseArgumentsIllegalValueException;
import com.github.rvesse.airline.parser.errors.ParseOptionIllegalValueException;
import com.github.rvesse.airline.restrictions.AbstractCommonRestriction;
import com.github.rvesse.airline.restrictions.common.AbstractAllowedValuesRestriction;
import com.github.rvesse.airline.utils.AirlineUtils;
import com.github.rvesse.airline.utils.predicates.LocaleSensitiveStringFinder;
import java.util.Locale;
import org.apache.commons.collections4.IterableUtils;

public class AllowedRawValuesRestriction
extends AbstractAllowedValuesRestriction {
    private final Locale locale;

    public AllowedRawValuesRestriction(boolean ignoreCase, Locale locale, String ... values) {
        super(ignoreCase);
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        this.locale = locale;
        for (String value : values) {
            if (ignoreCase) {
                value = value.toLowerCase(locale);
            }
            this.rawValues.add(value);
        }
    }

    @Override
    public <T> void preValidate(ParseState<T> state, OptionMetadata option, String value) {
        if (this.rawValues.isEmpty()) {
            return;
        }
        if (this.caseInsensitive) {
            value = value.toLowerCase(this.locale);
        }
        if (!IterableUtils.matchesAny(this.rawValues, new LocaleSensitiveStringFinder(value, this.locale))) {
            throw new ParseOptionIllegalValueException(AirlineUtils.first(option.getOptions()), AbstractCommonRestriction.getOptionTitle(state, option), (Object)value, AllowedRawValuesRestriction.asObjects(this.rawValues));
        }
    }

    @Override
    public <T> void preValidate(ParseState<T> state, ArgumentsMetadata arguments, String value) {
        if (this.rawValues.isEmpty()) {
            return;
        }
        if (this.caseInsensitive) {
            value = value.toLowerCase(this.locale);
        }
        if (!IterableUtils.matchesAny(this.rawValues, new LocaleSensitiveStringFinder(value, this.locale))) {
            throw new ParseArgumentsIllegalValueException(AbstractCommonRestriction.getArgumentTitle(state, arguments), (Object)value, AllowedRawValuesRestriction.asObjects(this.rawValues));
        }
    }
}

