/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.net;

import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.LifeCycle;
import java.util.ArrayList;
import java.util.List;

public class URLEvaluator
extends ContextAwareBase
implements EventEvaluator,
LifeCycle {
    boolean started;
    String name;
    private List<String> URLList = new ArrayList<String>();

    public void addURL(String url) {
        this.URLList.add(url);
    }

    @Override
    public void start() {
        if (this.URLList.size() == 0) {
            this.addWarn("No URL was given to URLEvaluator");
        } else {
            this.started = true;
        }
    }

    public boolean evaluate(Object eventObject) throws NullPointerException, EvaluationException {
        IAccessEvent event = (IAccessEvent)eventObject;
        String url = event.getRequestURL();
        for (String expected : this.URLList) {
            if (!url.contains(expected)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void stop() {
        this.started = false;
    }
}

