/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.web.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import graphql.ExecutionInput;
import graphql.GraphQL;
import graphql.GraphqlErrorException;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.common.grpc.SchemaReads;
import io.stargate.sgv2.common.grpc.StargateBridgeClient;
import io.stargate.sgv2.graphql.web.models.GraphqlJsonBody;
import io.stargate.sgv2.graphql.web.resources.GraphqlCache;
import io.stargate.sgv2.graphql.web.resources.StargateGraphqlContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/json"})
public class GraphqlResourceBase {
    private static final Logger LOG = LoggerFactory.getLogger(GraphqlResourceBase.class);
    protected static final String APPLICATION_GRAPHQL = "application/graphql";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<Map<String, List<String>>> FILES_MAPPING_TYPE = new TypeReference<Map<String, List<String>>>(){};
    private static final Splitter PATH_SPLITTER = Splitter.on(".");
    @Inject
    protected GraphqlCache graphqlCache;

    protected void get(String query, String operationName, String variables, GraphQL graphql, HttpServletRequest httpRequest, AsyncResponse asyncResponse, StargateBridgeClient bridge) {
        if (Strings.isNullOrEmpty(query)) {
            throw GraphqlResourceBase.graphqlError(Response.Status.BAD_REQUEST, "You must provide a GraphQL query as a URL parameter");
        }
        try {
            ExecutionInput.Builder input = ExecutionInput.newExecutionInput(query).operationName(operationName).context(new StargateGraphqlContext(httpRequest, bridge, this.graphqlCache));
            if (!Strings.isNullOrEmpty(variables)) {
                Map parsedVariables = OBJECT_MAPPER.readValue(variables, Map.class);
                input = input.variables(parsedVariables);
            }
            GraphqlResourceBase.executeAsync(input.build(), graphql, asyncResponse);
        }
        catch (IOException e) {
            throw GraphqlResourceBase.graphqlError(Response.Status.BAD_REQUEST, "Could not parse variables: " + e.getMessage());
        }
    }

    protected void postJson(GraphqlJsonBody jsonBody, String queryFromUrl, GraphQL graphql, HttpServletRequest httpRequest, AsyncResponse asyncResponse, StargateBridgeClient bridge) {
        Map<String, Object> variables;
        queryFromUrl = Strings.emptyToNull(queryFromUrl);
        String queryFromBody = jsonBody == null ? null : Strings.emptyToNull(jsonBody.getQuery());
        String operationName = jsonBody == null ? null : Strings.emptyToNull(jsonBody.getOperationName());
        Map<String, Object> map = variables = jsonBody == null ? null : jsonBody.getVariables();
        if (queryFromBody == null && queryFromUrl == null) {
            throw GraphqlResourceBase.graphqlError(Response.Status.BAD_REQUEST, "You must provide a GraphQL query, either as a query parameter or in the request body");
        }
        if (queryFromBody != null && queryFromUrl != null) {
            throw GraphqlResourceBase.graphqlError(Response.Status.BAD_REQUEST, "You can't provide a GraphQL query both as a query parameter and in the request body");
        }
        String query = MoreObjects.firstNonNull(queryFromBody, queryFromUrl);
        ExecutionInput.Builder input = ExecutionInput.newExecutionInput(query).operationName(operationName).context(new StargateGraphqlContext(httpRequest, bridge, this.graphqlCache));
        if (variables != null) {
            input = input.variables(variables);
        }
        GraphqlResourceBase.executeAsync(input.build(), graphql, asyncResponse);
    }

    protected void postMultipartJson(GraphqlJsonBody jsonBody, FormDataMultiPart allParts, GraphQL graphql, HttpServletRequest httpRequest, AsyncResponse asyncResponse, StargateBridgeClient bridge) {
        if (jsonBody == null) {
            throw GraphqlResourceBase.graphqlError(Response.Status.BAD_REQUEST, "Could not find GraphQL operations object. Make sure your multipart request includes an 'operations' part with MIME type application/json");
        }
        GraphqlResourceBase.bindFilesToVariables(jsonBody, allParts, asyncResponse);
        this.postJson(jsonBody, null, graphql, httpRequest, asyncResponse, bridge);
    }

    private static void bindFilesToVariables(GraphqlJsonBody jsonBody, FormDataMultiPart allParts, AsyncResponse asyncResponse) {
        Map<String, Object> variables = jsonBody.getVariables();
        FormDataBodyPart filesMappingPart = allParts.getField("map");
        if (filesMappingPart != null) {
            Map<String, List<String>> filesMapping;
            if (variables == null || variables.isEmpty()) {
                throw GraphqlResourceBase.graphqlError(Response.Status.BAD_REQUEST, "Found a 'map' part but the GraphQL query has no variables");
            }
            try {
                filesMapping = OBJECT_MAPPER.readValue(filesMappingPart.getValue(), FILES_MAPPING_TYPE);
            }
            catch (JsonProcessingException e) {
                throw GraphqlResourceBase.graphqlError(Response.Status.BAD_REQUEST, "Could not parse map part: " + e.getMessage());
            }
            for (Map.Entry<String, List<String>> entry : filesMapping.entrySet()) {
                String partName = entry.getKey();
                List<String> variablePaths = entry.getValue();
                FormDataBodyPart part = allParts.getField(partName);
                if (part == null) {
                    throw GraphqlResourceBase.graphqlError(Response.Status.BAD_REQUEST, String.format("The 'map' part references '%s', but found no part with that name", partName));
                }
                if (variablePaths == null || variablePaths.size() != 1) {
                    String message = String.format("This implementation only allows file parts to reference exactly one variable (offending part: '%s' with %d variables)", partName, variablePaths == null ? 0 : variablePaths.size());
                    throw GraphqlResourceBase.graphqlError(Response.Status.BAD_REQUEST, message);
                }
                String variablePath = variablePaths.get(0);
                List<String> pathElements = PATH_SPLITTER.splitToList(variablePath);
                if (pathElements.size() != 2 && !"variables".equals(pathElements.get(0))) {
                    throw GraphqlResourceBase.graphqlError(Response.Status.BAD_REQUEST, String.format("This implementation only allows simple variable references like 'variables.x' (offending reference: '%s')", variablePath));
                }
                String variableName = pathElements.get(1);
                variables.put(variableName, part.getEntityAs(InputStream.class));
            }
        }
    }

    protected void postGraphql(String query, GraphQL graphql, HttpServletRequest httpRequest, AsyncResponse asyncResponse, StargateBridgeClient bridge) {
        if (Strings.isNullOrEmpty(query)) {
            throw GraphqlResourceBase.graphqlError(Response.Status.BAD_REQUEST, "You must provide a GraphQL query in the request body");
        }
        ExecutionInput input = ExecutionInput.newExecutionInput(query).context(new StargateGraphqlContext(httpRequest, bridge, this.graphqlCache)).build();
        GraphqlResourceBase.executeAsync(input, graphql, asyncResponse);
    }

    protected static void executeAsync(ExecutionInput input, GraphQL graphql, @Suspended AsyncResponse asyncResponse) {
        graphql.executeAsync(input).whenComplete((result, error) -> {
            if (error != null) {
                LOG.error("Unexpected error while processing GraphQL request", (Throwable)error);
                throw GraphqlResourceBase.graphqlError(Response.Status.INTERNAL_SERVER_ERROR, "Internal server error");
            }
            StargateGraphqlContext context = (StargateGraphqlContext)input.getContext();
            if (context.isOverloaded()) {
                throw GraphqlResourceBase.graphqlError(Response.Status.TOO_MANY_REQUESTS, "Database is overloaded");
            }
            asyncResponse.resume(result.toSpecification());
        });
    }

    protected boolean isAuthorized(String keyspaceName, StargateBridgeClient bridge) {
        return bridge.authorizeSchemaRead(SchemaReads.keyspace(keyspaceName, Schema.SchemaRead.SourceApi.GRAPHQL));
    }

    protected static WebApplicationException graphqlError(Response.Status status, String message) {
        return new WebApplicationException(Response.status(status).entity(ImmutableMap.of("errors", ImmutableList.of(ImmutableMap.of("message", message)))).build());
    }

    protected static WebApplicationException graphqlError(Response.Status status, GraphqlErrorException error) {
        return new WebApplicationException(Response.status(status).entity(ImmutableMap.of("errors", ImmutableList.of(error.toSpecification()))).build());
    }
}

