/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.web.resources;

import graphql.schema.idl.SchemaPrinter;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.stargate.sgv2.common.grpc.StargateBridgeClient;
import io.stargate.sgv2.common.http.CreateStargateBridgeClient;
import io.stargate.sgv2.graphql.persistence.graphqlfirst.SchemaSource;
import io.stargate.sgv2.graphql.persistence.graphqlfirst.SchemaSourceDao;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.CqlDirectives;
import io.stargate.sgv2.graphql.schema.scalars.CqlScalar;
import io.stargate.sgv2.graphql.web.resources.DmlResource;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/graphql-files")
@CreateStargateBridgeClient
public class FilesResource {
    private static final Logger LOG = LoggerFactory.getLogger(FilesResource.class);
    private static final String DIRECTIVES_RESPONSE = FilesResource.buildDirectivesResponse();

    @GET
    @Path(value="/cql_directives.graphql")
    @Produces(value={"text/plain"})
    public Response getCqlDirectives() {
        return Response.ok(DIRECTIVES_RESPONSE).header("Content-Disposition", "inline; filename=\"cql_directives.graphql\"").build();
    }

    @GET
    @Path(value="/keyspace/{keyspaceName}.graphql")
    @Produces(value={"text/plain"})
    public Response getSchema(@HeaderParam(value="X-Cassandra-Token") String token, @PathParam(value="keyspaceName") String keyspace, @QueryParam(value="version") String version, @Context HttpServletRequest httpRequest, @Context StargateBridgeClient bridge) {
        if (!DmlResource.KEYSPACE_NAME_PATTERN.matcher(keyspace).matches()) {
            LOG.warn("Malformed keyspace in URI, this could be an XSS attack: {}", (Object)keyspace);
            throw new WebApplicationException("Malformed keyspace name", Response.Status.BAD_REQUEST);
        }
        UUID versionUuid = null;
        if (version != null) {
            try {
                versionUuid = UUID.fromString(version);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Malformed version in URI, this could be an XSS attack: {}", (Object)version);
                throw new WebApplicationException("Malformed version", Response.Status.BAD_REQUEST);
            }
        }
        try {
            return new SchemaSourceDao(bridge).getSingleVersion(keyspace, Optional.ofNullable(versionUuid)).map(schemaSource -> Response.ok(schemaSource.getContents()).header("Content-Disposition", "inline; filename=" + this.createFileName((SchemaSource)schemaSource)).build()).orElseThrow(() -> new WebApplicationException(String.format("The schema for keyspace %s and version %s does not exist.", keyspace, version), Response.Status.NOT_FOUND));
        }
        catch (Exception e) {
            if (e instanceof StatusRuntimeException && ((StatusRuntimeException)e).getStatus().getCode() == Status.Code.UNAUTHENTICATED) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            throw e;
        }
    }

    private String createFileName(SchemaSource schemaSource) {
        return String.format("\"%s-%s.graphql\"", schemaSource.getKeyspace(), schemaSource.getVersion());
    }

    private static String buildDirectivesResponse() {
        StringBuilder result = new StringBuilder(CqlDirectives.ALL_AS_STRING);
        result.append('\n');
        SchemaPrinter schemaPrinter = new SchemaPrinter();
        for (CqlScalar cqlScalar : CqlScalar.values()) {
            result.append(schemaPrinter.print(cqlScalar.getGraphqlType()));
        }
        return result.toString();
    }
}

