/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.processor;

import com.apollographql.federation.graphqljava.Federation;
import com.apollographql.federation.graphqljava._FieldSet;
import com.apollographql.federation.graphqljava.tracing.FederatedTracingInstrumentation;
import com.google.common.collect.ImmutableMap;
import graphql.GraphQL;
import graphql.GraphQLError;
import graphql.GraphqlErrorException;
import graphql.execution.AsyncExecutionStrategy;
import graphql.language.Argument;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectiveLocation;
import graphql.language.EnumTypeDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.SchemaTransformer;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.errors.SchemaProblem;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TreeTransformerUtil;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.common.grpc.StargateBridgeClient;
import io.stargate.sgv2.graphql.schema.CassandraFetcherExceptionHandler;
import io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.deployed.FederatedEntity;
import io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.deployed.FederatedEntityFetcher;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.CqlDirectives;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.FieldModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.MappingModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.OperationModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ProcessedSchema;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.sgv2.graphql.schema.graphqlfirst.util.TypeHelper;
import io.stargate.sgv2.graphql.schema.scalars.CqlScalar;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SchemaProcessor {
    private static final TypeDefinitionRegistry FEDERATION_DIRECTIVES = new SchemaParser().parse(new InputStreamReader(Objects.requireNonNull(SchemaProcessor.class.getResourceAsStream("/schemafirst/federation.graphql")), StandardCharsets.UTF_8));
    private static final DirectiveDefinition ATOMIC_DIRECTIVE = DirectiveDefinition.newDirectiveDefinition().name("atomic").description(new Description("Instructs the server to apply the mutations in a LOGGED batch", null, false)).directiveLocation(DirectiveLocation.newDirectiveLocation().name("MUTATION").build()).build();
    private final StargateBridgeClient bridge;
    private final boolean isPersisted;

    public SchemaProcessor(StargateBridgeClient bridge, boolean isPersisted) {
        this.bridge = bridge;
        this.isPersisted = isPersisted;
    }

    public ProcessedSchema process(String source, Schema.CqlKeyspaceDescribe keyspace) {
        TypeDefinitionRegistry registry = this.parse(source);
        ProcessingContext context = new ProcessingContext(registry, keyspace, this.bridge, this.isPersisted);
        MappingModel mappingModel = MappingModel.build(registry, context);
        this.addGeneratedTypes(mappingModel, registry);
        GraphQL graphql = this.buildGraphql(registry, mappingModel, context.getUsedCqlScalars(), keyspace);
        return new ProcessedSchema(mappingModel, graphql, context.getLogs());
    }

    private void addGeneratedTypes(MappingModel mappingModel, TypeDefinitionRegistry registry) {
        mappingModel.getEntities().values().stream().filter(e -> e.getInputTypeName().isPresent()).forEach(e -> registry.add(this.generateInputType((EntityModel)e, mappingModel)));
    }

    private InputObjectTypeDefinition generateInputType(EntityModel entity, MappingModel mappingModel) {
        assert (entity.getInputTypeName().isPresent());
        InputObjectTypeDefinition.Builder builder = InputObjectTypeDefinition.newInputObjectDefinition().name(entity.getInputTypeName().get());
        entity.getAllColumns().forEach(c -> {
            Type type = c.getGraphqlType();
            if (c.isPrimaryKey() && TypeHelper.mapsToUuid(type) && type instanceof NonNullType) {
                type = ((NonNullType)type).getType();
            }
            type = this.substituteUdtInputTypes(type, mappingModel);
            builder.inputValueDefinition(InputValueDefinition.newInputValueDefinition().name(c.getGraphqlName()).type(type).build());
        });
        return builder.build();
    }

    private Type<?> substituteUdtInputTypes(Type<?> type, MappingModel mappingModel) {
        if (type instanceof ListType) {
            Type elementType = ((ListType)type).getType();
            return ListType.newListType(this.substituteUdtInputTypes(elementType, mappingModel)).build();
        }
        if (type instanceof NonNullType) {
            Type elementType = ((NonNullType)type).getType();
            return NonNullType.newNonNullType(this.substituteUdtInputTypes(elementType, mappingModel)).build();
        }
        assert (type instanceof TypeName);
        EntityModel entity = mappingModel.getEntities().get(((TypeName)type).getName());
        if (entity != null) {
            assert (entity.getInputTypeName().isPresent());
            return TypeName.newTypeName(entity.getInputTypeName().get()).build();
        }
        return type;
    }

    private GraphQL buildGraphql(TypeDefinitionRegistry registry, MappingModel mappingModel, EnumSet<CqlScalar> cqlScalars, Schema.CqlKeyspaceDescribe keyspace) {
        GraphQL.Builder graphqlBuilder;
        if (mappingModel.hasFederatedEntities()) {
            registry = registry.merge(FEDERATION_DIRECTIVES);
            this.finalizeKeyDirectives(registry, mappingModel);
            this.stubQueryTypeIfNeeded(registry, mappingModel);
        }
        registry = registry.merge(CqlDirectives.ALL_AS_REGISTRY);
        registry.add(ATOMIC_DIRECTIVE);
        RuntimeWiring.Builder runtimeWiring = RuntimeWiring.newRuntimeWiring().codeRegistry(this.buildCodeRegistry(mappingModel)).scalar(_FieldSet.type);
        for (CqlScalar cqlScalar : cqlScalars) {
            registry.add(ScalarTypeDefinition.newScalarTypeDefinition().name(cqlScalar.getGraphqlType().getName()).build());
            runtimeWiring.scalar(cqlScalar.getGraphqlType());
        }
        GraphQLSchema schema = new SchemaGenerator().makeExecutableSchema(SchemaGenerator.Options.defaultOptions(), registry, runtimeWiring.build());
        schema = SchemaProcessor.removeCqlDirectives(schema);
        if (mappingModel.hasFederatedEntities()) {
            GraphQLSchema federationReadySchema = Federation.transform(schema).fetchEntities(new FederatedEntityFetcher(mappingModel, keyspace)).resolveEntityType(environment -> {
                FederatedEntity entity = (FederatedEntity)environment.getObject();
                return environment.getSchema().getObjectType(entity.getTypeName());
            }).build();
            graphqlBuilder = GraphQL.newGraphQL(federationReadySchema).instrumentation(new FederatedTracingInstrumentation());
        } else {
            graphqlBuilder = GraphQL.newGraphQL(schema);
        }
        return graphqlBuilder.defaultDataFetcherExceptionHandler(CassandraFetcherExceptionHandler.INSTANCE).mutationExecutionStrategy(new AsyncExecutionStrategy(CassandraFetcherExceptionHandler.INSTANCE)).build();
    }

    private void finalizeKeyDirectives(TypeDefinitionRegistry registry, MappingModel mappingModel) {
        if (!mappingModel.hasFederatedEntities()) {
            return;
        }
        for (EntityModel entity : mappingModel.getEntities().values()) {
            if (!entity.isFederated()) continue;
            ObjectTypeDefinition type = registry.getType(entity.getGraphqlName(), ObjectTypeDefinition.class).orElseThrow(() -> new AssertionError((Object)"Should find type in registry since we've built an EntityModel from it"));
            List<Directive> keyDirectives = type.getDirectives("key");
            assert (keyDirectives.size() == 1);
            Directive keyDirective = (Directive)keyDirectives.iterator().next();
            if (keyDirective.getArgument("fields") != null) continue;
            String newFieldsValue = entity.getPrimaryKey().stream().map(FieldModel::getGraphqlName).collect(Collectors.joining(" "));
            Directive newKeyDirective = Directive.newDirective().name("key").argument(Argument.newArgument("fields", StringValue.newStringValue(newFieldsValue).build()).build()).build();
            List newDirectives = type.getDirectives().stream().map(d -> d == keyDirective ? newKeyDirective : d).collect(Collectors.toList());
            ObjectTypeDefinition newType = type.transform(builder -> builder.directives(newDirectives));
            registry.remove(type);
            registry.add(newType);
        }
    }

    private void stubQueryTypeIfNeeded(TypeDefinitionRegistry registry, MappingModel mappingModel) {
        if (!mappingModel.hasUserQueries()) {
            registry.add(ObjectTypeDefinition.newObjectTypeDefinition().name("Query").fieldDefinition(FieldDefinition.newFieldDefinition().name("_entities").type(TypeName.newTypeName("Int").build()).build()).build());
        }
    }

    private TypeDefinitionRegistry parse(String source) throws GraphqlErrorException {
        SchemaParser parser = new SchemaParser();
        try {
            return parser.parse(source);
        }
        catch (SchemaProblem schemaProblem) {
            List<GraphQLError> schemaErrors = schemaProblem.getErrors();
            List errorsJson = schemaErrors.stream().map(GraphQLError::toSpecification).collect(Collectors.toList());
            String schemaOrigin = this.isPersisted ? "stored for this keyspace" : "that you provided";
            throw ((GraphqlErrorException.Builder)((GraphqlErrorException.Builder)GraphqlErrorException.newErrorException().message(String.format("The schema %s is not valid GraphQL. See details in `extensions.schemaErrors` below.", schemaOrigin))).extensions(ImmutableMap.of("schemaErrors", errorsJson))).build();
        }
    }

    private GraphQLCodeRegistry buildCodeRegistry(MappingModel mappingModel) {
        GraphQLCodeRegistry.Builder builder = GraphQLCodeRegistry.newCodeRegistry();
        for (OperationModel operation : mappingModel.getOperations()) {
            builder.dataFetcher(operation.getCoordinates(), operation.getDataFetcher(mappingModel));
        }
        return builder.build();
    }

    private static GraphQLSchema removeCqlDirectives(GraphQLSchema schema) {
        return new SchemaTransformer().transform(schema, (GraphQLTypeVisitor)new GraphQLTypeVisitorStub(){

            @Override
            public TraversalControl visitGraphQLEnumType(GraphQLEnumType node, TraverserContext<GraphQLSchemaElement> context) {
                if (CqlDirectives.ALL_AS_REGISTRY.getType(node.getName()).filter(t -> t instanceof EnumTypeDefinition).isPresent()) {
                    TreeTransformerUtil.deleteNode(context);
                }
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl visitGraphQLDirective(GraphQLDirective node, TraverserContext<GraphQLSchemaElement> context) {
                if (CqlDirectives.ALL_AS_REGISTRY.getDirectiveDefinition(node.getName()).isPresent()) {
                    TreeTransformerUtil.deleteNode(context);
                }
                return TraversalControl.CONTINUE;
            }
        });
    }
}

