/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.processor;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import graphql.language.SourceLocation;
import graphql.schema.idl.TypeDefinitionRegistry;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.common.grpc.StargateBridgeClient;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ProcessingErrorType;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ProcessingLogType;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ProcessingMessage;
import io.stargate.sgv2.graphql.schema.scalars.CqlScalar;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

class ProcessingContext {
    private final TypeDefinitionRegistry typeRegistry;
    private final Schema.CqlKeyspaceDescribe keyspace;
    private final StargateBridgeClient bridge;
    private final boolean isPersisted;
    private final EnumSet<CqlScalar> usedCqlScalars = EnumSet.noneOf(CqlScalar.class);
    private final List<ProcessingMessage<ProcessingLogType>> logs;
    private final List<ProcessingMessage<ProcessingErrorType>> errors;

    ProcessingContext(TypeDefinitionRegistry typeRegistry, Schema.CqlKeyspaceDescribe keyspace, StargateBridgeClient bridge, boolean isPersisted) {
        this.typeRegistry = typeRegistry;
        this.keyspace = keyspace;
        this.bridge = bridge;
        this.isPersisted = isPersisted;
        this.logs = new ArrayList<ProcessingMessage<ProcessingLogType>>();
        this.errors = new ArrayList<ProcessingMessage<ProcessingErrorType>>();
    }

    TypeDefinitionRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    Schema.CqlKeyspaceDescribe getKeyspace() {
        return this.keyspace;
    }

    public StargateBridgeClient getBridge() {
        return this.bridge;
    }

    public boolean isPersisted() {
        return this.isPersisted;
    }

    EnumSet<CqlScalar> getUsedCqlScalars() {
        return this.usedCqlScalars;
    }

    @FormatMethod
    void addInfo(SourceLocation location, @FormatString String format, Object ... arguments) {
        this.logs.add(ProcessingMessage.log(location, ProcessingLogType.Info, format, arguments));
    }

    @FormatMethod
    void addWarning(SourceLocation location, @FormatString String format, Object ... arguments) {
        this.logs.add(ProcessingMessage.log(location, ProcessingLogType.Warning, format, arguments));
    }

    @FormatMethod
    void addError(SourceLocation location, ProcessingErrorType messageType, @FormatString String format, Object ... arguments) {
        this.errors.add(ProcessingMessage.error(location, messageType, format, arguments));
    }

    List<ProcessingMessage<ProcessingLogType>> getLogs() {
        return this.logs;
    }

    List<ProcessingMessage<ProcessingErrorType>> getErrors() {
        return this.errors;
    }
}

