/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.processor;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import graphql.language.Directive;
import io.stargate.bridge.grpc.TypeSpecs;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.common.cql.builder.CollectionIndexingType;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.DirectiveHelper;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.IndexModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ModelBuilderBase;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.SkipException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

class IndexModelBuilder
extends ModelBuilderBase<IndexModel> {
    private static final Splitter.MapSplitter OPTIONS_SPLITTER = Splitter.on(',').withKeyValueSeparator(Splitter.on(':').trimResults(CharMatcher.anyOf("' ")));
    private final Directive cqlIndexDirective;
    private final String parentCqlName;
    private final String columnCqlName;
    private final QueryOuterClass.TypeSpec cqlType;
    private final String messagePrefix;

    IndexModelBuilder(Directive cqlIndexDirective, String parentCqlName, String columnCqlName, QueryOuterClass.TypeSpec cqlType, String messagePrefix, ProcessingContext context) {
        super(context, cqlIndexDirective.getSourceLocation());
        this.cqlIndexDirective = cqlIndexDirective;
        this.parentCqlName = parentCqlName;
        this.columnCqlName = columnCqlName;
        this.cqlType = cqlType;
        this.messagePrefix = messagePrefix;
    }

    @Override
    IndexModel build() throws SkipException {
        String indexName = DirectiveHelper.getStringArgument(this.cqlIndexDirective, "name", this.context).orElse(this.parentCqlName + '_' + this.columnCqlName + "_idx");
        Optional<String> indexClass = DirectiveHelper.getStringArgument(this.cqlIndexDirective, "class", this.context);
        Schema.SupportedFeaturesResponse supportedFeatures = this.context.getBridge().getSupportedFeatures();
        if (!indexClass.isPresent() && !supportedFeatures.getSecondaryIndexes()) {
            if (!this.context.getBridge().getSupportedFeatures().getSai()) {
                this.invalidMapping("%s: the persistence backend does not support regular secondary indexes nor SAI, indexes that don't specify %s can't be mapped", this.messagePrefix, "class");
                throw SkipException.INSTANCE;
            }
            this.info("%s: using SAI for index %s because the persistence backend does not support regular secondary indexes", this.messagePrefix, indexName);
            indexClass = Optional.of("org.apache.cassandra.index.sai.StorageAttachedIndex");
        }
        Schema.IndexingType indexingType = DirectiveHelper.getEnumArgument(this.cqlIndexDirective, "target", CollectionIndexingType.class, this.context).filter(this::validateTarget).map(this::toGrpc).orElse(TypeSpecs.isCollection(this.cqlType) ? Schema.IndexingType.VALUES_ : Schema.IndexingType.DEFAULT);
        Map<String, String> indexOptions = DirectiveHelper.getStringArgument(this.cqlIndexDirective, "options", this.context).flatMap(this::convertOptions).orElse(Collections.emptyMap());
        if (this.cqlType.hasUdt() && !this.cqlType.getUdt().getFrozen()) {
            this.invalidMapping("%s: fields that map to UDTs can only be indexed if they are frozen", this.messagePrefix);
            throw SkipException.INSTANCE;
        }
        return new IndexModel(indexName, indexClass, indexingType, indexOptions);
    }

    private boolean validateTarget(CollectionIndexingType indexTarget) {
        switch (indexTarget) {
            case KEYS: 
            case ENTRIES: {
                if (this.cqlType.hasMap()) break;
                this.invalidMapping("%s: index target %s can only be used for map columns", new Object[]{this.messagePrefix, indexTarget});
                return false;
            }
            case VALUES: {
                if (TypeSpecs.isCollection(this.cqlType) && !TypeSpecs.isFrozen(this.cqlType)) break;
                this.invalidMapping("%s: index target %s can only be used for non-frozen collection columns", new Object[]{this.messagePrefix, indexTarget});
                return false;
            }
            case FULL: {
                if (TypeSpecs.isCollection(this.cqlType) && TypeSpecs.isFrozen(this.cqlType)) break;
                this.invalidMapping("%s: index target %s can only be used for frozen collection columns", new Object[]{this.messagePrefix, indexTarget});
                return false;
            }
            default: {
                throw new AssertionError((Object)("Unsupported target " + (Object)((Object)indexTarget)));
            }
        }
        return true;
    }

    private Schema.IndexingType toGrpc(CollectionIndexingType type) {
        switch (type) {
            case KEYS: {
                return Schema.IndexingType.KEYS;
            }
            case VALUES: {
                return Schema.IndexingType.VALUES_;
            }
            case ENTRIES: {
                return Schema.IndexingType.ENTRIES;
            }
            case FULL: {
                return Schema.IndexingType.FULL;
            }
        }
        throw new IllegalArgumentException("Unexpected type " + (Object)((Object)type));
    }

    private Optional<Map<String, String>> convertOptions(String rawOptions) {
        try {
            return Optional.of(OPTIONS_SPLITTER.split(rawOptions));
        }
        catch (IllegalArgumentException e) {
            this.invalidMapping("%s: invalid format for options. Expected 'option1':'value1','option2','value2'...", this.messagePrefix);
            return Optional.empty();
        }
    }
}

