/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.processor;

import graphql.language.Type;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.IndexModel;
import java.util.Optional;

public class FieldModel {
    private final String graphqlName;
    private final Type<?> graphqlType;
    private final String cqlName;
    private final QueryOuterClass.TypeSpec cqlType;
    private final boolean partitionKey;
    private final Optional<Schema.ColumnOrderBy> clusteringOrder;
    private final Optional<IndexModel> index;

    FieldModel(String graphqlName, Type<?> graphqlType, String cqlName, QueryOuterClass.TypeSpec cqlType, boolean partitionKey, Optional<Schema.ColumnOrderBy> clusteringOrder, Optional<IndexModel> index) {
        this.graphqlName = graphqlName;
        this.graphqlType = graphqlType;
        this.cqlName = cqlName;
        this.cqlType = cqlType;
        this.partitionKey = partitionKey;
        this.clusteringOrder = clusteringOrder;
        this.index = index;
    }

    public String getGraphqlName() {
        return this.graphqlName;
    }

    public Type<?> getGraphqlType() {
        return this.graphqlType;
    }

    public String getCqlName() {
        return this.cqlName;
    }

    public QueryOuterClass.TypeSpec getCqlType() {
        return this.cqlType;
    }

    public boolean isPartitionKey() {
        return this.partitionKey;
    }

    public FieldModel asPartitionKey() {
        return new FieldModel(this.graphqlName, this.graphqlType, this.cqlName, this.cqlType, true, this.clusteringOrder, this.index);
    }

    public Optional<Schema.ColumnOrderBy> getClusteringOrder() {
        return this.clusteringOrder;
    }

    public boolean isClusteringColumn() {
        return this.getClusteringOrder().isPresent();
    }

    public boolean isPrimaryKey() {
        return this.partitionKey || this.clusteringOrder.isPresent();
    }

    public Optional<IndexModel> getIndex() {
        return this.index;
    }
}

