/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.processor;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.StringValue;
import graphql.language.Directive;
import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.DirectiveHelper;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.FieldModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.FieldModelBuilder;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ModelBuilderBase;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.SkipException;
import io.stargate.sgv2.graphql.schema.graphqlfirst.util.TypeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityModelBuilder
extends ModelBuilderBase<EntityModel> {
    private static final Logger LOG = LoggerFactory.getLogger(EntityModelBuilder.class);
    private static final Pattern NON_NESTED_FIELDS = Pattern.compile("[_A-Za-z][_0-9A-Za-z]*(?:\\s+[_A-Za-z][_0-9A-Za-z]*)*");
    private static final Splitter ON_SPACES = Splitter.onPattern("\\s+");
    private final ObjectTypeDefinition type;
    private final String graphqlName;

    EntityModelBuilder(ObjectTypeDefinition type, ProcessingContext context) {
        super(context, type.getSourceLocation());
        this.type = type;
        this.graphqlName = type.getName();
    }

    @Override
    EntityModel build() throws SkipException {
        QueryOuterClass.TypeSpec.Udt udtCqlSchema;
        Schema.CqlTable tableCqlSchema;
        Optional<Directive> cqlEntityDirective = DirectiveHelper.getDirective("cql_entity", this.type);
        String cqlName = this.providedCqlNameOrDefault(cqlEntityDirective);
        EntityModel.Target target = this.providedTargetOrDefault(cqlEntityDirective);
        Optional<String> inputTypeName = DirectiveHelper.getDirective("cql_input", this.type).map(this::providedInputNameOrDefault);
        ArrayList<FieldModel> partitionKey = new ArrayList<FieldModel>();
        ArrayList<FieldModel> clusteringColumns = new ArrayList<FieldModel>();
        ArrayList<FieldModel> regularColumns = new ArrayList<FieldModel>();
        for (FieldDefinition fieldDefinition : this.type.getFieldDefinitions()) {
            try {
                FieldModel fieldMapping = new FieldModelBuilder(fieldDefinition, this.context, cqlName, this.graphqlName, target, inputTypeName.isPresent()).build();
                if (fieldMapping.isPartitionKey()) {
                    partitionKey.add(fieldMapping);
                    continue;
                }
                if (fieldMapping.getClusteringOrder().isPresent()) {
                    clusteringColumns.add(fieldMapping);
                    continue;
                }
                regularColumns.add(fieldMapping);
            }
            catch (SkipException e) {
                LOG.debug("Skipping field {} because it has mapping errors, this will be reported after the whole schema has been processed.", (Object)fieldDefinition.getName());
            }
        }
        switch (target) {
            case TABLE: {
                if (!this.hasPartitionKey(partitionKey, regularColumns)) {
                    this.invalidMapping("%s must have at least one partition key field (use scalar type ID, Uuid or TimeUuid for the first field, or annotate your fields with @%s(%s: true))", new Object[]{this.graphqlName, "cql_column", "partitionKey"});
                    throw SkipException.INSTANCE;
                }
                tableCqlSchema = EntityModelBuilder.buildCqlTable(cqlName, partitionKey, clusteringColumns, regularColumns);
                udtCqlSchema = null;
                break;
            }
            case UDT: {
                if (regularColumns.isEmpty()) {
                    this.invalidMapping("%s must have at least one field", new Object[]{this.graphqlName});
                    throw SkipException.INSTANCE;
                }
                tableCqlSchema = null;
                udtCqlSchema = EntityModelBuilder.buildCqlUdt(cqlName, regularColumns);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected target " + (Object)((Object)target)));
            }
        }
        return new EntityModel(this.graphqlName, this.context.getKeyspace().getCqlKeyspace().getName(), cqlName, target, partitionKey, clusteringColumns, regularColumns, tableCqlSchema, udtCqlSchema, this.isFederated(partitionKey, clusteringColumns, target), inputTypeName);
    }

    private String providedCqlNameOrDefault(Optional<Directive> cqlEntityDirective) {
        return cqlEntityDirective.flatMap(d -> DirectiveHelper.getStringArgument(d, "name", this.context)).orElse(this.graphqlName);
    }

    private EntityModel.Target providedTargetOrDefault(Optional<Directive> cqlEntityDirective) {
        return cqlEntityDirective.flatMap(d -> DirectiveHelper.getEnumArgument(d, "target", EntityModel.Target.class, this.context)).orElse(EntityModel.Target.TABLE);
    }

    private String providedInputNameOrDefault(Directive cqlInputDirective) {
        Optional<String> maybeName = DirectiveHelper.getStringArgument(cqlInputDirective, "name", this.context);
        if (maybeName.isPresent()) {
            return maybeName.get();
        }
        this.info("%1$s: using '%1$sInput' as the input type name since @%2$s doesn't have an argument", this.graphqlName, "cql_input");
        return this.graphqlName + "Input";
    }

    private boolean hasPartitionKey(List<FieldModel> partitionKey, List<FieldModel> regularColumns) {
        if (!partitionKey.isEmpty()) {
            return true;
        }
        FieldModel firstField = regularColumns.get(0);
        if (TypeHelper.mapsToUuid(firstField.getGraphqlType())) {
            this.info("%s: using %s as the partition key, because it has type %s and no other fields are annotated", this.graphqlName, firstField.getGraphqlName(), TypeHelper.format(TypeHelper.unwrapNonNull(firstField.getGraphqlType())));
            partitionKey.add(firstField.asPartitionKey());
            regularColumns.remove(firstField);
            return true;
        }
        return false;
    }

    private boolean isFederated(List<FieldModel> partitionKey, List<FieldModel> clusteringColumns, EntityModel.Target target) throws SkipException {
        List<Directive> keyDirectives = this.type.getDirectives("key");
        if (keyDirectives.isEmpty()) {
            return false;
        }
        if (target == EntityModel.Target.UDT) {
            this.invalidMapping("%s: can't use @key directive because this type maps to a UDT", new Object[]{this.graphqlName});
            throw SkipException.INSTANCE;
        }
        if (keyDirectives.size() > 1) {
            this.invalidMapping("%s: this implementation only supports a single @key directive", new Object[]{this.graphqlName});
            throw SkipException.INSTANCE;
        }
        Directive keyDirective = keyDirectives.get(0);
        Optional<String> fieldsArgument = DirectiveHelper.getStringArgument(keyDirective, "fields", this.context);
        if (fieldsArgument.isPresent()) {
            Set primaryKeyFields;
            String value = fieldsArgument.get();
            if (!NON_NESTED_FIELDS.matcher(value).matches()) {
                this.invalidMapping("%s: could not parse @key.fields (this implementation only supports top-level fields as key components)", new Object[]{this.graphqlName});
                throw SkipException.INSTANCE;
            }
            ImmutableSet<String> directiveFields = ImmutableSet.copyOf(ON_SPACES.split(value));
            if (!directiveFields.equals(primaryKeyFields = Stream.concat(partitionKey.stream(), clusteringColumns.stream()).map(FieldModel::getGraphqlName).collect(Collectors.toSet()))) {
                this.invalidMapping("%s: @key.fields doesn't match the partition and clustering keys (expected %s)", new Object[]{this.graphqlName, primaryKeyFields});
                throw SkipException.INSTANCE;
            }
        }
        return true;
    }

    private static Schema.CqlTable buildCqlTable(String tableName, List<FieldModel> partitionKey, List<FieldModel> clusteringColumns, List<FieldModel> regularColumns) {
        Schema.CqlTable.Builder table = Schema.CqlTable.newBuilder().setName(tableName);
        for (FieldModel column : partitionKey) {
            table.addPartitionKeyColumns(QueryOuterClass.ColumnSpec.newBuilder().setName(column.getCqlName()).setType(column.getCqlType()));
        }
        for (FieldModel column : clusteringColumns) {
            table.addClusteringKeyColumns(QueryOuterClass.ColumnSpec.newBuilder().setName(column.getCqlName()).setType(column.getCqlType()));
            table.putClusteringOrders(column.getCqlName(), column.getClusteringOrder().orElse(Schema.ColumnOrderBy.ASC));
        }
        for (FieldModel column : regularColumns) {
            table.addColumns(QueryOuterClass.ColumnSpec.newBuilder().setName(column.getCqlName()).setType(column.getCqlType()));
            column.getIndex().ifPresent(index -> {
                Schema.CqlIndex.Builder builder = Schema.CqlIndex.newBuilder().setColumnName(column.getCqlName()).setName(index.getName()).setIndexingType(index.getIndexingType()).putAllOptions(index.getOptions());
                index.getIndexClass().ifPresent(c -> builder.setIndexingClass(StringValue.of(c)));
                table.addIndexes(builder);
            });
        }
        return table.build();
    }

    private static QueryOuterClass.TypeSpec.Udt buildCqlUdt(String udtName, List<FieldModel> fields) {
        QueryOuterClass.TypeSpec.Udt.Builder udt = QueryOuterClass.TypeSpec.Udt.newBuilder().setName(udtName);
        for (FieldModel field : fields) {
            udt.putFields(field.getCqlName(), field.getCqlType());
        }
        return udt.build();
    }
}

