/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.processor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import graphql.language.Directive;
import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ArgumentDirectiveModels;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ConditionModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.DirectiveHelper;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.FieldModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.IfConditionModelBuilder;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.IncrementModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.IncrementModelBuilder;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ModelBuilderBase;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ProcessingContext;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.SkipException;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.WhereConditionModelBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class ArgumentDirectiveModelsBuilder
extends ModelBuilderBase<ArgumentDirectiveModels> {
    private final FieldDefinition operation;
    private final String operationName;
    private final OperationType operationType;
    private final EntityModel entity;
    private final Map<String, EntityModel> entities;

    ArgumentDirectiveModelsBuilder(FieldDefinition operation, OperationType operationType, EntityModel entity, Map<String, EntityModel> entities, ProcessingContext context) {
        super(context, operation.getSourceLocation());
        this.operation = operation;
        this.operationName = operation.getName();
        this.operationType = operationType;
        this.entity = entity;
        this.entities = entities;
    }

    @Override
    ArgumentDirectiveModels build() throws SkipException {
        ImmutableList.Builder<ConditionModel> whereConditions = ImmutableList.builder();
        ImmutableList.Builder<ConditionModel> ifConditions = ImmutableList.builder();
        ImmutableList.Builder<IncrementModel> increments = ImmutableList.builder();
        boolean hasErrors = false;
        for (InputValueDefinition inputValue : this.operation.getInputValueDefinitions()) {
            try {
                this.buildArgument(inputValue, whereConditions, ifConditions, increments);
            }
            catch (SkipException e) {
                hasErrors = true;
            }
        }
        if (hasErrors) {
            throw SkipException.INSTANCE;
        }
        return new ArgumentDirectiveModels((List<ConditionModel>)((Object)ifConditions.build()), (List<ConditionModel>)((Object)whereConditions.build()), (List<IncrementModel>)((Object)increments.build()));
    }

    private void buildArgument(InputValueDefinition inputValue, ImmutableList.Builder<ConditionModel> whereConditions, ImmutableList.Builder<ConditionModel> ifConditions, ImmutableList.Builder<IncrementModel> increments) throws SkipException {
        Set<Directive> directives = this.collectDirectives(inputValue, "cql_pagingState", "cql_where", "cql_if", "cql_increment", "cql_timestamp");
        if (directives.size() > 1) {
            this.reportTooManyDirectives(directives, inputValue);
            throw SkipException.INSTANCE;
        }
        Optional<Directive> directive = directives.stream().findFirst();
        if (this.is(directive, "cql_pagingState") || this.is(directive, "cql_timestamp")) {
            return;
        }
        FieldModel field = this.findField(inputValue, directive);
        switch (this.operationType) {
            case SELECT: {
                this.buildSelectArgument(inputValue, directive, field, whereConditions);
                break;
            }
            case DELETE: {
                this.buildDeleteArgument(inputValue, directive, field, whereConditions, ifConditions);
                break;
            }
            case UPDATE: {
                this.buildUpdateArgument(inputValue, directive, field, whereConditions, ifConditions, increments);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown operation type " + (Object)((Object)this.operationType)));
            }
        }
    }

    private Set<Directive> collectDirectives(InputValueDefinition inputValue, String ... directiveNames) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (String directiveName : directiveNames) {
            DirectiveHelper.getDirective(directiveName, inputValue).ifPresent(result::add);
        }
        return result.build();
    }

    private boolean is(Optional<Directive> directive, String directiveName) {
        return directive.filter(d -> d.getName().equals(directiveName)).isPresent();
    }

    private FieldModel findField(InputValueDefinition inputValue, Optional<Directive> directive) throws SkipException {
        String fieldName = directive.flatMap(d -> DirectiveHelper.getStringArgument(d, "field", this.context)).orElse(inputValue.getName());
        return this.entity.getAllColumns().stream().filter(f -> f.getGraphqlName().equals(fieldName)).findFirst().orElseThrow(() -> {
            this.invalidMapping("Operation %s: could not find field %s in type %s", this.operationName, fieldName, this.entity.getGraphqlName());
            return SkipException.INSTANCE;
        });
    }

    private void buildSelectArgument(InputValueDefinition inputValue, Optional<Directive> directive, FieldModel field, ImmutableList.Builder<ConditionModel> whereConditions) throws SkipException {
        if (this.is(directive, "cql_if") || this.is(directive, "cql_increment")) {
            this.reportDirectiveNotAllowed(inputValue, directive, "SELECT arguments");
        }
        whereConditions.add((Object)this.newWhereCondition(inputValue, directive, field));
    }

    private void buildDeleteArgument(InputValueDefinition inputValue, Optional<Directive> directive, FieldModel field, ImmutableList.Builder<ConditionModel> whereConditions, ImmutableList.Builder<ConditionModel> ifConditions) throws SkipException {
        if (this.is(directive, "cql_increment")) {
            this.reportDirectiveNotAllowed(inputValue, directive, "DELETE arguments");
        }
        if (this.is(directive, "cql_if")) {
            ifConditions.add((Object)this.newIfCondition(inputValue, directive, field));
        } else {
            whereConditions.add((Object)this.newWhereCondition(inputValue, directive, field));
        }
    }

    private void buildUpdateArgument(InputValueDefinition inputValue, Optional<Directive> directive, FieldModel field, ImmutableList.Builder<ConditionModel> whereConditions, ImmutableList.Builder<ConditionModel> ifConditions, ImmutableList.Builder<IncrementModel> increments) throws SkipException {
        if (field.isPrimaryKey()) {
            if (this.is(directive, "cql_if") || this.is(directive, "cql_increment")) {
                this.reportDirectiveNotAllowed(inputValue, directive, "UPDATE primary key arguments");
                throw SkipException.INSTANCE;
            }
            whereConditions.add((Object)this.newWhereCondition(inputValue, directive, field));
        } else {
            if (this.is(directive, "cql_where")) {
                this.reportDirectiveNotAllowed(inputValue, directive, "UPDATE non-primary key arguments");
                throw SkipException.INSTANCE;
            }
            if (this.is(directive, "cql_if")) {
                ifConditions.add((Object)this.newIfCondition(inputValue, directive, field));
            } else if (this.is(directive, "cql_increment")) {
                increments.add((Object)this.newIncrement(inputValue, directive, field));
            }
        }
    }

    private ConditionModel newWhereCondition(InputValueDefinition inputValue, Optional<Directive> directive, FieldModel field) throws SkipException {
        return new WhereConditionModelBuilder(inputValue, directive, this.entity, field, this.operationName, this.entities, this.context).build();
    }

    private ConditionModel newIfCondition(InputValueDefinition inputValue, Optional<Directive> directive, FieldModel field) throws SkipException {
        return new IfConditionModelBuilder(inputValue, directive, this.entity, field, this.operationName, this.entities, this.context).build();
    }

    private IncrementModel newIncrement(InputValueDefinition inputValue, Optional<Directive> directive, FieldModel field) throws SkipException {
        return new IncrementModelBuilder(inputValue, directive, this.entity, field, this.operationName, this.entities, this.context).build();
    }

    private void reportTooManyDirectives(Set<Directive> directives, InputValueDefinition inputValue) {
        this.invalidMapping("Operation %s: argument %s can only use one of %s", this.operationName, inputValue.getName(), directives.stream().map(d -> "@" + d.getName()).collect(Collectors.joining(",")));
    }

    private void reportDirectiveNotAllowed(InputValueDefinition inputValue, Optional<Directive> directive, String inputValueDescription) {
        assert (directive.isPresent());
        this.invalidMapping("Operation %s: @%s is not allowed on %s (%s)", this.operationName, directive.get().getName(), inputValueDescription, inputValue.getName());
    }

    static enum OperationType {
        SELECT,
        DELETE,
        UPDATE;

    }
}

