/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.migration;

import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import java.util.List;

public abstract class MigrationQuery {
    protected String keyspaceName;

    protected MigrationQuery(String keyspaceName) {
        this.keyspaceName = keyspaceName;
    }

    public abstract QueryOuterClass.Query build();

    public abstract String getDescription();

    public abstract boolean mustRunBefore(MigrationQuery var1);

    protected abstract boolean addsReferenceTo(String var1);

    protected abstract boolean dropsReferenceTo(String var1);

    protected boolean references(QueryOuterClass.TypeSpec type, String udtName) {
        switch (type.getSpecCase()) {
            case UDT: {
                QueryOuterClass.TypeSpec.Udt udt = type.getUdt();
                return udt.getName().equals(udtName) || udt.getFieldsMap().values().stream().anyMatch(t -> this.references((QueryOuterClass.TypeSpec)t, udtName));
            }
            case LIST: {
                return this.references(type.getList().getElement(), udtName);
            }
            case SET: {
                return this.references(type.getSet().getElement(), udtName);
            }
            case TUPLE: {
                QueryOuterClass.TypeSpec.Tuple tuple = type.getTuple();
                return tuple.getElementsList().stream().anyMatch(t -> this.references((QueryOuterClass.TypeSpec)t, udtName));
            }
        }
        return false;
    }

    protected boolean references(String udtName, Schema.CqlTable table) {
        return this.references(udtName, table.getPartitionKeyColumnsList()) || this.references(udtName, table.getClusteringKeyColumnsList()) || this.references(udtName, table.getColumnsList()) || this.references(udtName, table.getStaticColumnsList());
    }

    private boolean references(String udtName, List<QueryOuterClass.ColumnSpec> columns) {
        return columns.stream().anyMatch(c -> this.references(c.getType(), udtName));
    }

    protected boolean references(String udtName, QueryOuterClass.TypeSpec.Udt type) {
        return type.getFieldsMap().values().stream().anyMatch(t -> this.references((QueryOuterClass.TypeSpec)t, udtName));
    }
}

