/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.migration;

import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.common.cql.builder.QueryBuilder;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.CreateTableQuery;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.DropUdtQuery;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.MigrationQuery;

public class DropTableQuery
extends MigrationQuery {
    private final Schema.CqlTable table;

    public DropTableQuery(String keyspaceName, Schema.CqlTable table) {
        super(keyspaceName);
        this.table = table;
    }

    public String getTableName() {
        return this.table.getName();
    }

    @Override
    public QueryOuterClass.Query build() {
        return new QueryBuilder().drop().table(this.keyspaceName, this.table.getName()).ifExists().build();
    }

    @Override
    public String getDescription() {
        return "Drop table " + this.table.getName();
    }

    @Override
    public boolean mustRunBefore(MigrationQuery that) {
        if (that instanceof CreateTableQuery) {
            return this.table.getName().equals(((CreateTableQuery)that).getTableName());
        }
        if (that instanceof DropUdtQuery) {
            return this.dropsReferenceTo(((DropUdtQuery)that).getTypeName());
        }
        return false;
    }

    @Override
    public boolean addsReferenceTo(String udtName) {
        return false;
    }

    @Override
    public boolean dropsReferenceTo(String udtName) {
        return this.references(udtName, this.table);
    }
}

