/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.migration;

import io.stargate.bridge.grpc.TypeSpecs;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.sgv2.common.cql.builder.Column;
import io.stargate.sgv2.common.cql.builder.ImmutableColumn;
import io.stargate.sgv2.common.cql.builder.QueryBuilder;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.MigrationQuery;
import java.util.List;
import java.util.stream.Collectors;

public class CreateUdtQuery
extends MigrationQuery {
    private final QueryOuterClass.TypeSpec.Udt type;

    public CreateUdtQuery(String keyspaceName, QueryOuterClass.TypeSpec.Udt type) {
        super(keyspaceName);
        this.type = type;
    }

    public String getTypeName() {
        return this.type.getName();
    }

    @Override
    public QueryOuterClass.Query build() {
        return new QueryBuilder().create().type(this.keyspaceName, this.type.getName()).column(this.buildFields()).build();
    }

    private List<Column> buildFields() {
        return this.type.getFieldsMap().entrySet().stream().map(e -> ImmutableColumn.builder().name((String)e.getKey()).type(TypeSpecs.format((QueryOuterClass.TypeSpec)e.getValue())).kind(Column.Kind.REGULAR).build()).collect(Collectors.toList());
    }

    @Override
    public String getDescription() {
        return "Create UDT " + this.type.getName();
    }

    @Override
    public boolean mustRunBefore(MigrationQuery that) {
        return that.addsReferenceTo(this.type.getName());
    }

    @Override
    public boolean addsReferenceTo(String udtName) {
        return this.references(udtName, this.type);
    }

    @Override
    public boolean dropsReferenceTo(String udtName) {
        return false;
    }
}

