/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.migration;

import com.google.common.collect.ImmutableList;
import io.stargate.bridge.grpc.TypeSpecs;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.common.cql.builder.Column;
import io.stargate.sgv2.common.cql.builder.ImmutableColumn;
import io.stargate.sgv2.common.cql.builder.QueryBuilder;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.CreateIndexQuery;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.MigrationQuery;
import java.util.List;

public class CreateTableQuery
extends MigrationQuery {
    private final Schema.CqlTable table;

    public static List<MigrationQuery> createTableAndIndexes(String keyspaceName, Schema.CqlTable table) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(new CreateTableQuery(keyspaceName, table));
        for (Schema.CqlIndex index : table.getIndexesList()) {
            builder.add(new CreateIndexQuery(keyspaceName, table.getName(), index));
        }
        return builder.build();
    }

    public CreateTableQuery(String keyspaceName, Schema.CqlTable table) {
        super(keyspaceName);
        this.table = table;
    }

    public String getTableName() {
        return this.table.getName();
    }

    @Override
    public QueryOuterClass.Query build() {
        return new QueryBuilder().create().table(this.keyspaceName, this.table.getName()).column(this.buildColumns()).build();
    }

    private List<Column> buildColumns() {
        ImmutableList.Builder columns = ImmutableList.builder();
        for (QueryOuterClass.ColumnSpec column : this.table.getPartitionKeyColumnsList()) {
            columns.add(ImmutableColumn.builder().name(column.getName()).type(TypeSpecs.format(column.getType())).kind(Column.Kind.PARTITION_KEY).build());
        }
        for (QueryOuterClass.ColumnSpec column : this.table.getClusteringKeyColumnsList()) {
            Schema.ColumnOrderBy order = this.table.getClusteringOrdersMap().get(column.getName());
            columns.add(ImmutableColumn.builder().name(column.getName()).type(TypeSpecs.format(column.getType())).kind(Column.Kind.CLUSTERING).order(order == Schema.ColumnOrderBy.ASC ? Column.Order.ASC : Column.Order.DESC).build());
        }
        for (QueryOuterClass.ColumnSpec column : this.table.getColumnsList()) {
            columns.add(ImmutableColumn.builder().name(column.getName()).type(TypeSpecs.format(column.getType())).kind(Column.Kind.REGULAR).build());
        }
        for (QueryOuterClass.ColumnSpec column : this.table.getStaticColumnsList()) {
            columns.add(ImmutableColumn.builder().name(column.getName()).type(TypeSpecs.format(column.getType())).kind(Column.Kind.STATIC).build());
        }
        return columns.build();
    }

    @Override
    public String getDescription() {
        return "Create table " + this.table.getName();
    }

    @Override
    public boolean mustRunBefore(MigrationQuery that) {
        return that instanceof CreateIndexQuery && ((CreateIndexQuery)that).getTableName().equals(this.getTableName());
    }

    @Override
    public boolean addsReferenceTo(String udtName) {
        return this.references(udtName, this.table);
    }

    @Override
    public boolean dropsReferenceTo(String udtName) {
        return false;
    }
}

