/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.migration;

import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.common.cql.builder.CollectionIndexingType;
import io.stargate.sgv2.common.cql.builder.QueryBuilder;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.MigrationQuery;

public class CreateIndexQuery
extends MigrationQuery {
    private final String tableName;
    private final Schema.CqlIndex index;

    public CreateIndexQuery(String keyspaceName, String tableName, Schema.CqlIndex index) {
        super(keyspaceName);
        this.tableName = tableName;
        this.index = index;
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public QueryOuterClass.Query build() {
        return new QueryBuilder().create().index(this.index.getName()).on(this.keyspaceName, this.tableName).column(this.index.getColumnName()).indexingType(CreateIndexQuery.convert(this.index.getIndexingType())).custom(this.index.hasIndexingClass() ? this.index.getIndexingClass().getValue() : null).options(this.index.getOptionsMap()).build();
    }

    @Override
    public String getDescription() {
        return String.format("Create index %s on %s.%s", this.index.getName(), this.tableName, this.index.getColumnName());
    }

    @Override
    public boolean mustRunBefore(MigrationQuery that) {
        return false;
    }

    @Override
    protected boolean addsReferenceTo(String udtName) {
        return false;
    }

    @Override
    protected boolean dropsReferenceTo(String udtName) {
        return false;
    }

    private static CollectionIndexingType convert(Schema.IndexingType indexingType) {
        switch (indexingType) {
            case DEFAULT: {
                return null;
            }
            case KEYS: {
                return CollectionIndexingType.KEYS;
            }
            case VALUES_: {
                return CollectionIndexingType.VALUES;
            }
            case ENTRIES: {
                return CollectionIndexingType.ENTRIES;
            }
            case FULL: {
                return CollectionIndexingType.FULL;
            }
        }
        throw new IllegalArgumentException("Unsupported indexing type " + indexingType);
    }
}

