/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.migration;

import com.google.common.collect.Maps;
import io.stargate.bridge.grpc.TypeSpecs;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.common.cql.builder.Column;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CassandraSchemaHelper {
    public static List<Difference> compare(Schema.CqlTable expectedTable, Schema.CqlTable actualTable) {
        String tableName = expectedTable.getName();
        if (!tableName.equals(actualTable.getName())) {
            throw new IllegalArgumentException("This should only be called for tables with the same name");
        }
        ArrayList<Difference> differences = new ArrayList<Difference>();
        Map<String, ExtendedColumn> expectedColumns = CassandraSchemaHelper.indexColumns(expectedTable);
        Map<String, ExtendedColumn> actualColumns = CassandraSchemaHelper.indexColumns(actualTable);
        for (Map.Entry<String, ExtendedColumn> entry : expectedColumns.entrySet()) {
            String columnName = entry.getKey();
            ExtendedColumn expectedColumn = entry.getValue();
            ExtendedColumn actualColumn = actualColumns.get(columnName);
            CassandraSchemaHelper.compareColumn(expectedColumn, actualColumn, differences);
            Schema.CqlIndex expectedIndex = CassandraSchemaHelper.findSecondaryIndex(expectedTable, columnName);
            if (expectedIndex == null) continue;
            Schema.CqlIndex actualIndex = CassandraSchemaHelper.findSecondaryIndex(actualTable, columnName);
            CassandraSchemaHelper.compareIndex(expectedIndex, actualIndex, expectedColumn, differences);
        }
        return differences;
    }

    private static Map<String, ExtendedColumn> indexColumns(Schema.CqlTable table) {
        HashMap<String, ExtendedColumn> columns = Maps.newHashMapWithExpectedSize(table.getPartitionKeyColumnsCount() + table.getClusteringKeyColumnsCount() + table.getColumnsCount() + table.getStaticColumnsCount());
        for (QueryOuterClass.ColumnSpec column : table.getPartitionKeyColumnsList()) {
            columns.put(column.getName(), new ExtendedColumn(table.getName(), column, Column.Kind.PARTITION_KEY));
        }
        for (QueryOuterClass.ColumnSpec column : table.getClusteringKeyColumnsList()) {
            String name = column.getName();
            columns.put(name, new ExtendedColumn(table.getName(), column, Column.Kind.CLUSTERING, table.getClusteringOrdersMap().get(name)));
        }
        for (QueryOuterClass.ColumnSpec column : table.getColumnsList()) {
            columns.put(column.getName(), new ExtendedColumn(table.getName(), column, Column.Kind.REGULAR));
        }
        for (QueryOuterClass.ColumnSpec column : table.getStaticColumnsList()) {
            columns.put(column.getName(), new ExtendedColumn(table.getName(), column, Column.Kind.STATIC));
        }
        return columns;
    }

    private static void compareColumn(ExtendedColumn expectedColumn, ExtendedColumn actualColumn, List<Difference> differences) {
        QueryOuterClass.TypeSpec expectedType = expectedColumn.spec.getType();
        if (actualColumn == null) {
            String description = null;
            if (expectedColumn.kind == Column.Kind.PARTITION_KEY) {
                description = "it can't be added because it is marked as a partition key";
            } else if (expectedColumn.kind == Column.Kind.CLUSTERING) {
                description = "it can't be added because it is marked as a clustering column";
            }
            differences.add(new Difference(expectedColumn, DifferenceType.MISSING_COLUMN, description));
        } else if (!CassandraSchemaHelper.equals(expectedType, actualColumn.getSpec().getType())) {
            differences.add(new Difference(expectedColumn, DifferenceType.WRONG_TYPE, String.format("expected %s, found %s", TypeSpecs.format(expectedType), TypeSpecs.format(actualColumn.getSpec().getType()))));
        } else if (expectedColumn.kind != actualColumn.kind) {
            differences.add(new Difference(expectedColumn, DifferenceType.WRONG_KIND, String.format("expected %s, found %s", new Object[]{expectedColumn.kind, actualColumn.kind})));
        } else if (expectedColumn.getKind() == Column.Kind.CLUSTERING && expectedColumn.getOrder() != actualColumn.getOrder()) {
            differences.add(new Difference(expectedColumn, DifferenceType.WRONG_CLUSTERING_ORDER, String.format("expected %s, found %s", expectedColumn.getOrder(), actualColumn.getOrder())));
        }
    }

    private static boolean equals(QueryOuterClass.TypeSpec expectedType, QueryOuterClass.TypeSpec actualType) {
        if (actualType.getSpecCase() != expectedType.getSpecCase()) {
            return false;
        }
        switch (actualType.getSpecCase()) {
            case BASIC: {
                return actualType.getBasic() == expectedType.getBasic();
            }
            case MAP: {
                QueryOuterClass.TypeSpec.Map actualMap = actualType.getMap();
                QueryOuterClass.TypeSpec.Map expectedMap = expectedType.getMap();
                return CassandraSchemaHelper.equals(expectedMap.getKey(), actualMap.getKey()) && CassandraSchemaHelper.equals(expectedMap.getValue(), actualMap.getValue());
            }
            case LIST: {
                QueryOuterClass.TypeSpec.List actualList = actualType.getList();
                QueryOuterClass.TypeSpec.List expectedList = expectedType.getList();
                return CassandraSchemaHelper.equals(expectedList.getElement(), actualList.getElement());
            }
            case SET: {
                QueryOuterClass.TypeSpec.Set actualSet = actualType.getSet();
                QueryOuterClass.TypeSpec.Set expectedSet = expectedType.getSet();
                return CassandraSchemaHelper.equals(expectedSet.getElement(), actualSet.getElement());
            }
            case UDT: {
                return actualType.getUdt().getName().equals(expectedType.getUdt().getName());
            }
            case TUPLE: {
                QueryOuterClass.TypeSpec.Tuple actualTuple = actualType.getTuple();
                QueryOuterClass.TypeSpec.Tuple expectedTuple = expectedType.getTuple();
                if (actualTuple.getElementsCount() != expectedTuple.getElementsCount()) {
                    return false;
                }
                for (int i = 0; i < actualTuple.getElementsCount(); ++i) {
                    if (CassandraSchemaHelper.equals(expectedTuple.getElements(i), actualTuple.getElements(i))) continue;
                    return false;
                }
                return true;
            }
        }
        throw new AssertionError((Object)("Unexpected type " + actualType.getSpecCase()));
    }

    private static Schema.CqlIndex findSecondaryIndex(Schema.CqlTable table, String columnName) {
        for (Schema.CqlIndex index : table.getIndexesList()) {
            if (!columnName.equals(index.getColumnName())) continue;
            return index;
        }
        return null;
    }

    private static void compareIndex(Schema.CqlIndex expectedIndex, Schema.CqlIndex actualIndex, ExtendedColumn expectedColumn, List<Difference> differences) {
        if (actualIndex == null) {
            differences.add(new Difference(expectedColumn, expectedIndex, DifferenceType.MISSING_INDEX, null));
            return;
        }
        String description = null;
        if (!Objects.equals(expectedIndex.getName(), actualIndex.getName())) {
            description = String.format("expected name %s, found %s", expectedIndex.getName(), actualIndex.getName());
        } else if (!Objects.equals(expectedIndex.getIndexingClass(), actualIndex.getIndexingClass())) {
            String expectedClass = expectedIndex.hasIndexingClass() ? expectedIndex.getIndexingClass().getValue() : "<none>";
            String actualClass = actualIndex.hasIndexingClass() ? actualIndex.getIndexingClass().getValue() : "<none>";
            description = String.format("expected index class %s, found %s", expectedClass, actualClass);
        } else if (!Objects.equals(expectedIndex.getIndexingType(), actualIndex.getIndexingType())) {
            description = String.format("expected index target %s, found %s", expectedIndex.getIndexingType(), actualIndex.getIndexingType());
        } else if (!Objects.equals(expectedIndex.getOptionsMap(), actualIndex.getOptionsMap())) {
            description = String.format("expected index options %s, found %s", expectedIndex.getOptionsMap(), actualIndex.getOptionsMap());
        }
        if (description != null) {
            differences.add(new Difference(expectedColumn, expectedIndex, DifferenceType.WRONG_INDEX, description));
        }
    }

    public static List<Difference> compare(QueryOuterClass.TypeSpec.Udt expectedUdt, QueryOuterClass.TypeSpec.Udt actualUdt) {
        String typeName = expectedUdt.getName();
        if (!typeName.equals(actualUdt.getName())) {
            throw new IllegalArgumentException("This should only be called for UDTs with the same name");
        }
        ArrayList<Difference> differences = new ArrayList<Difference>();
        Map<String, QueryOuterClass.TypeSpec> actualFields = actualUdt.getFieldsMap();
        for (Map.Entry<String, QueryOuterClass.TypeSpec> entry : expectedUdt.getFieldsMap().entrySet()) {
            String fieldName = entry.getKey();
            QueryOuterClass.TypeSpec expectedType = entry.getValue();
            QueryOuterClass.TypeSpec actualType = actualFields.get(fieldName);
            if (actualType == null) {
                String description = null;
                differences.add(new Difference(CassandraSchemaHelper.toColumn(expectedUdt.getName(), fieldName, expectedType), DifferenceType.MISSING_COLUMN, description));
                continue;
            }
            if (CassandraSchemaHelper.equals(expectedType, actualType)) continue;
            differences.add(new Difference(CassandraSchemaHelper.toColumn(expectedUdt.getName(), fieldName, expectedType), DifferenceType.WRONG_TYPE, String.format("expected %s, found %s", TypeSpecs.format(expectedType), TypeSpecs.format(actualType))));
        }
        return differences;
    }

    private static ExtendedColumn toColumn(String udtName, String fieldName, QueryOuterClass.TypeSpec expectedType) {
        return new ExtendedColumn(udtName, QueryOuterClass.ColumnSpec.newBuilder().setName(fieldName).setType(expectedType).build(), Column.Kind.REGULAR);
    }

    private CassandraSchemaHelper() {
    }

    public static class ExtendedColumn {
        private final String tableName;
        private final QueryOuterClass.ColumnSpec spec;
        private final Column.Kind kind;
        private final Schema.ColumnOrderBy order;

        public ExtendedColumn(String tableName, QueryOuterClass.ColumnSpec spec, Column.Kind kind, Schema.ColumnOrderBy order) {
            this.tableName = tableName;
            this.spec = spec;
            this.kind = kind;
            this.order = order;
        }

        public ExtendedColumn(String tableName, QueryOuterClass.ColumnSpec spec, Column.Kind kind) {
            this(tableName, spec, kind, null);
        }

        public String getTableName() {
            return this.tableName;
        }

        public QueryOuterClass.ColumnSpec getSpec() {
            return this.spec;
        }

        public Column.Kind getKind() {
            return this.kind;
        }

        public Schema.ColumnOrderBy getOrder() {
            return this.order;
        }
    }

    public static class Difference {
        private final ExtendedColumn column;
        private final Schema.CqlIndex index;
        private final DifferenceType type;
        private final String description;

        public Difference(ExtendedColumn column, Schema.CqlIndex index, DifferenceType type, String description) {
            this.column = column;
            this.index = index;
            this.type = type;
            this.description = description;
        }

        public Difference(ExtendedColumn column, DifferenceType type, String description) {
            this(column, null, type, description);
        }

        public ExtendedColumn getColumn() {
            return this.column;
        }

        public Schema.CqlIndex getIndex() {
            return this.index;
        }

        public DifferenceType getType() {
            return this.type;
        }

        public String toGraphqlMessage() {
            return String.format("[%s] %s.%s%s", new Object[]{this.type, this.column.getTableName(), this.column.getSpec().getName(), this.description == null ? "" : ": " + this.description});
        }
    }

    public static enum DifferenceType {
        MISSING_COLUMN,
        WRONG_TYPE,
        WRONG_KIND,
        WRONG_CLUSTERING_ORDER,
        MISSING_INDEX,
        WRONG_INDEX;

    }
}

