/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.migration;

import com.google.common.collect.ImmutableMap;
import graphql.GraphqlErrorException;
import graphql.VisibleForTesting;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.common.cql.builder.Column;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.AddTableColumnQuery;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.AddUdtFieldQuery;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.CassandraSchemaHelper;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.CreateIndexQuery;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.CreateTableQuery;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.CreateUdtQuery;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.DropTableQuery;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.DropUdtQuery;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.MigrationQuery;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.MigrationStrategy;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.MappingModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.util.DirectedGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class CassandraMigrator {
    private final MigrationStrategy strategy;
    private final boolean isPersisted;

    public static CassandraMigrator forDeployment(MigrationStrategy strategy) {
        return new CassandraMigrator(strategy, false);
    }

    public static CassandraMigrator forPersisted() {
        return new CassandraMigrator(MigrationStrategy.USE_EXISTING, true);
    }

    private CassandraMigrator(MigrationStrategy strategy, boolean isPersisted) {
        this.strategy = strategy;
        this.isPersisted = isPersisted;
    }

    public List<MigrationQuery> compute(MappingModel mappingModel, Schema.CqlKeyspaceDescribe keyspace) {
        ArrayList<MigrationQuery> queries = new ArrayList<MigrationQuery>();
        ArrayList<String> errors = new ArrayList<String>();
        block4: for (EntityModel entity : mappingModel.getEntities().values()) {
            switch (entity.getTarget()) {
                case TABLE: {
                    Schema.CqlTable expectedTable = entity.getTableCqlSchema();
                    Optional<Schema.CqlTable> actualTable = keyspace.getTablesList().stream().filter(t -> t.getName().equals(entity.getCqlName())).findFirst();
                    this.compute(expectedTable, actualTable, keyspace.getCqlKeyspace().getName(), queries, errors);
                    continue block4;
                }
                case UDT: {
                    QueryOuterClass.TypeSpec.Udt expectedType = entity.getUdtCqlSchema();
                    Optional<QueryOuterClass.TypeSpec.Udt> actualType = keyspace.getTypesList().stream().filter(t -> t.getName().equals(entity.getCqlName())).findFirst();
                    this.compute(expectedType, actualType, keyspace.getCqlKeyspace().getName(), queries, errors);
                    continue block4;
                }
            }
            throw new AssertionError((Object)("Unexpected target " + (Object)((Object)entity.getTarget())));
        }
        if (!errors.isEmpty()) {
            String message = this.isPersisted ? "The GraphQL schema stored for this keyspace doesn't match the CQL data model anymore. It looks like the database was altered manually." : String.format("The GraphQL schema that you provided can't be mapped to the current CQL data model. Consider using a different migration strategy (current: %s).", new Object[]{this.strategy});
            throw ((GraphqlErrorException.Builder)((GraphqlErrorException.Builder)GraphqlErrorException.newErrorException().message(message + " See details in `extensions.migrationErrors` below.")).extensions(ImmutableMap.of("migrationErrors", errors))).build();
        }
        return CassandraMigrator.sortForExecution(queries);
    }

    private void compute(Schema.CqlTable expected, Optional<Schema.CqlTable> maybeActual, String keyspaceName, List<MigrationQuery> queries, List<String> errors) {
        switch (this.strategy) {
            case USE_EXISTING: {
                if (maybeActual.isPresent()) {
                    this.failIfMismatch(expected, maybeActual.get(), errors);
                    break;
                }
                errors.add(String.format("Missing table %s", expected.getName()));
                break;
            }
            case ADD_MISSING_TABLES: {
                if (maybeActual.isPresent()) {
                    this.failIfMismatch(expected, maybeActual.get(), errors);
                    break;
                }
                queries.addAll(CreateTableQuery.createTableAndIndexes(keyspaceName, expected));
                break;
            }
            case ADD_MISSING_TABLES_AND_COLUMNS: {
                if (maybeActual.isPresent()) {
                    this.addMissingColumns(expected, maybeActual.get(), keyspaceName, queries, errors);
                    break;
                }
                queries.addAll(CreateTableQuery.createTableAndIndexes(keyspaceName, expected));
                break;
            }
            case DROP_AND_RECREATE_ALL: {
                queries.add(new DropTableQuery(keyspaceName, expected));
                queries.addAll(CreateTableQuery.createTableAndIndexes(keyspaceName, expected));
                break;
            }
            case DROP_AND_RECREATE_IF_MISMATCH: {
                if (maybeActual.isPresent()) {
                    List<CassandraSchemaHelper.Difference> differences = CassandraSchemaHelper.compare(expected, maybeActual.get());
                    if (differences.isEmpty()) break;
                    queries.add(new DropTableQuery(keyspaceName, expected));
                    queries.addAll(CreateTableQuery.createTableAndIndexes(keyspaceName, expected));
                    break;
                }
                queries.addAll(CreateTableQuery.createTableAndIndexes(keyspaceName, expected));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected strategy " + (Object)((Object)this.strategy)));
            }
        }
    }

    private void failIfMismatch(Schema.CqlTable expected, Schema.CqlTable actual, List<String> errors) {
        List<CassandraSchemaHelper.Difference> differences = CassandraSchemaHelper.compare(expected, actual);
        if (!differences.isEmpty()) {
            errors.addAll(differences.stream().map(CassandraSchemaHelper.Difference::toGraphqlMessage).collect(Collectors.toList()));
        }
    }

    private void addMissingColumns(Schema.CqlTable expected, Schema.CqlTable actual, String keyspaceName, List<MigrationQuery> queries, List<String> errors) {
        List<CassandraSchemaHelper.Difference> differences = CassandraSchemaHelper.compare(expected, actual);
        if (!differences.isEmpty()) {
            List blockers = differences.stream().filter(d -> !this.isAddableColumn((CassandraSchemaHelper.Difference)d)).collect(Collectors.toList());
            if (blockers.isEmpty()) {
                for (CassandraSchemaHelper.Difference difference : differences) {
                    assert (this.isAddableColumn(difference));
                    if (difference.getType() == CassandraSchemaHelper.DifferenceType.MISSING_COLUMN) {
                        queries.add(new AddTableColumnQuery(keyspaceName, expected.getName(), difference.getColumn()));
                        continue;
                    }
                    if (difference.getType() != CassandraSchemaHelper.DifferenceType.MISSING_INDEX) continue;
                    queries.add(new CreateIndexQuery(keyspaceName, expected.getName(), difference.getIndex()));
                }
            } else {
                errors.addAll(blockers.stream().map(CassandraSchemaHelper.Difference::toGraphqlMessage).collect(Collectors.toList()));
            }
        }
    }

    private boolean isAddableColumn(CassandraSchemaHelper.Difference difference) {
        return (difference.getType() == CassandraSchemaHelper.DifferenceType.MISSING_COLUMN || difference.getType() == CassandraSchemaHelper.DifferenceType.MISSING_INDEX) && difference.getColumn().getKind() != Column.Kind.PARTITION_KEY && difference.getColumn().getKind() != Column.Kind.CLUSTERING;
    }

    private void compute(QueryOuterClass.TypeSpec.Udt expected, Optional<QueryOuterClass.TypeSpec.Udt> maybeActual, String keyspaceName, List<MigrationQuery> queries, List<String> errors) {
        switch (this.strategy) {
            case USE_EXISTING: {
                if (maybeActual.isPresent()) {
                    this.failIfMismatch(expected, maybeActual.get(), errors);
                    break;
                }
                errors.add(String.format("Missing UDT %s", expected.getName()));
                break;
            }
            case ADD_MISSING_TABLES: {
                if (maybeActual.isPresent()) {
                    this.failIfMismatch(expected, maybeActual.get(), errors);
                    break;
                }
                queries.add(new CreateUdtQuery(keyspaceName, expected));
                break;
            }
            case ADD_MISSING_TABLES_AND_COLUMNS: {
                if (maybeActual.isPresent()) {
                    this.addMissingColumns(expected, maybeActual.get(), keyspaceName, queries, errors);
                    break;
                }
                queries.add(new CreateUdtQuery(keyspaceName, expected));
                break;
            }
            case DROP_AND_RECREATE_ALL: {
                queries.add(new DropUdtQuery(keyspaceName, expected));
                queries.add(new CreateUdtQuery(keyspaceName, expected));
                break;
            }
            case DROP_AND_RECREATE_IF_MISMATCH: {
                if (maybeActual.isPresent()) {
                    List<CassandraSchemaHelper.Difference> differences = CassandraSchemaHelper.compare(expected, maybeActual.get());
                    if (differences.isEmpty()) break;
                    queries.add(new DropUdtQuery(keyspaceName, expected));
                    queries.add(new CreateUdtQuery(keyspaceName, expected));
                    break;
                }
                queries.add(new CreateUdtQuery(keyspaceName, expected));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected strategy " + (Object)((Object)this.strategy)));
            }
        }
    }

    private void failIfMismatch(QueryOuterClass.TypeSpec.Udt expected, QueryOuterClass.TypeSpec.Udt actual, List<String> errors) {
        List<CassandraSchemaHelper.Difference> differences = CassandraSchemaHelper.compare(expected, actual);
        if (!differences.isEmpty()) {
            errors.addAll(differences.stream().map(CassandraSchemaHelper.Difference::toGraphqlMessage).collect(Collectors.toList()));
        }
    }

    private void addMissingColumns(QueryOuterClass.TypeSpec.Udt expected, QueryOuterClass.TypeSpec.Udt actual, String keyspaceName, List<MigrationQuery> queries, List<String> errors) {
        List<CassandraSchemaHelper.Difference> differences = CassandraSchemaHelper.compare(expected, actual);
        if (!differences.isEmpty()) {
            List blockers = differences.stream().filter(d -> !this.isAddableColumn((CassandraSchemaHelper.Difference)d)).collect(Collectors.toList());
            if (blockers.isEmpty()) {
                for (CassandraSchemaHelper.Difference difference : differences) {
                    assert (this.isAddableColumn(difference));
                    if (difference.getType() != CassandraSchemaHelper.DifferenceType.MISSING_COLUMN) continue;
                    queries.add(new AddUdtFieldQuery(keyspaceName, expected.getName(), difference.getColumn().getSpec().getName(), difference.getColumn().getSpec().getType()));
                }
            } else {
                errors.addAll(blockers.stream().map(CassandraSchemaHelper.Difference::toGraphqlMessage).collect(Collectors.toList()));
            }
        }
    }

    @VisibleForTesting
    static List<MigrationQuery> sortForExecution(List<MigrationQuery> queries) {
        if (queries.size() < 2) {
            return queries;
        }
        DirectedGraph<MigrationQuery> graph = new DirectedGraph<MigrationQuery>((Collection<MigrationQuery>)queries);
        for (MigrationQuery query1 : queries) {
            for (MigrationQuery query2 : queries) {
                boolean isSame = query1 != query2;
                if (!isSame || !query1.mustRunBefore(query2)) continue;
                graph.addEdge(query1, query2);
            }
        }
        return graph.topologicalSort();
    }
}

