/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.migration;

import io.stargate.bridge.grpc.TypeSpecs;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.sgv2.common.cql.builder.QueryBuilder;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.MigrationQuery;

public class AddUdtFieldQuery
extends MigrationQuery {
    private final String udtName;
    private final String fieldName;
    private final QueryOuterClass.TypeSpec fieldType;

    public AddUdtFieldQuery(String keyspaceName, String udtName, String fieldName, QueryOuterClass.TypeSpec fieldType) {
        super(keyspaceName);
        this.udtName = udtName;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
    }

    @Override
    public QueryOuterClass.Query build() {
        return new QueryBuilder().alter().type(this.keyspaceName, this.udtName).addColumn(this.fieldName, TypeSpecs.format(this.fieldType)).build();
    }

    @Override
    public String getDescription() {
        return String.format("Add field %s to UDT %s", this.fieldName, this.udtName);
    }

    @Override
    public boolean mustRunBefore(MigrationQuery that) {
        return false;
    }

    @Override
    public boolean addsReferenceTo(String udtName) {
        return this.references(this.fieldType, udtName);
    }

    @Override
    public boolean dropsReferenceTo(String udtName) {
        return false;
    }
}

