/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.migration;

import io.stargate.bridge.grpc.TypeSpecs;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.sgv2.common.cql.builder.QueryBuilder;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.CassandraSchemaHelper;
import io.stargate.sgv2.graphql.schema.graphqlfirst.migration.MigrationQuery;

public class AddTableColumnQuery
extends MigrationQuery {
    private final String tableName;
    private final CassandraSchemaHelper.ExtendedColumn column;

    public AddTableColumnQuery(String keyspaceName, String tableName, CassandraSchemaHelper.ExtendedColumn column) {
        super(keyspaceName);
        this.tableName = tableName;
        this.column = column;
    }

    @Override
    public QueryOuterClass.Query build() {
        return new QueryBuilder().alter().table(this.keyspaceName, this.tableName).addColumn(this.column.getSpec().getName(), TypeSpecs.format(this.column.getSpec().getType())).build();
    }

    @Override
    public String getDescription() {
        return String.format("Add column %s to table %s", this.column.getSpec().getName(), this.tableName);
    }

    @Override
    public boolean mustRunBefore(MigrationQuery that) {
        if (that instanceof AddTableColumnQuery) {
            return false;
        }
        return !that.mustRunBefore(this);
    }

    @Override
    public boolean addsReferenceTo(String udtName) {
        return this.references(this.column.getSpec().getType(), udtName);
    }

    @Override
    public boolean dropsReferenceTo(String udtName) {
        return false;
    }
}

