/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.deployed;

import com.google.protobuf.Int32Value;
import graphql.schema.Coercing;
import graphql.schema.DataFetchingEnvironment;
import io.stargate.bridge.grpc.BytesValues;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.common.cql.builder.BuiltCondition;
import io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.deployed.DeployedFetcher;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.MappingModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.OperationModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.QueryModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.sgv2.graphql.schema.scalars.CqlScalar;
import io.stargate.sgv2.graphql.web.resources.StargateGraphqlContext;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class QueryFetcher
extends DeployedFetcher<Object> {
    private static final Coercing<ByteBuffer, String> BLOB_COERCING = CqlScalar.BLOB.getGraphqlType().getCoercing();
    private final QueryModel model;

    public QueryFetcher(QueryModel model, MappingModel mappingModel, Schema.CqlKeyspaceDescribe keyspace) {
        super(mappingModel, keyspace);
        this.model = model;
    }

    protected QueryOuterClass.QueryParameters buildParameters(DataFetchingEnvironment environment) {
        Optional<ByteBuffer> pagingState = this.model.getPagingStateArgumentName().filter(environment::containsArgument).map(name -> BLOB_COERCING.parseValue(environment.getArgument((String)name)));
        int pageSize = this.model.getPageSize().orElse(100);
        QueryOuterClass.ConsistencyValue consistencyLevel = this.model.getConsistencyLevel().map(c -> QueryOuterClass.ConsistencyValue.newBuilder().setValue((QueryOuterClass.Consistency)c).build()).orElse(DEFAULT_CONSISTENCY);
        if (!pagingState.isPresent() && pageSize == 100 && consistencyLevel == DEFAULT_CONSISTENCY) {
            return DEFAULT_PARAMETERS;
        }
        QueryOuterClass.QueryParameters.Builder builder = DEFAULT_PARAMETERS.toBuilder().setPageSize(Int32Value.of(pageSize)).setConsistency(consistencyLevel);
        pagingState.ifPresent(byteBuffer -> builder.setPagingState(BytesValues.of(byteBuffer)));
        return builder.build();
    }

    @Override
    protected Object get(DataFetchingEnvironment environment, StargateGraphqlContext context) {
        Object entityData;
        OperationModel.ReturnType returnType = this.model.getReturnType();
        List<BuiltCondition> whereConditions = this.bindWhere(this.model.getWhereConditions(), environment::containsArgument, environment::getArgument, this.model.getEntity()::validateNoFiltering, this.keyspace);
        QueryOuterClass.ResultSet resultSet = this.query(this.model.getEntity(), whereConditions, this.model.getLimit(), this.buildParameters(environment), (StargateGraphqlContext)environment.getContext());
        Object object = entityData = returnType.isList() ? this.toEntities(resultSet, this.model.getEntity()) : this.toSingleEntity(resultSet, this.model.getEntity());
        if (returnType instanceof ResponsePayloadModel) {
            ResponsePayloadModel payloadModel = (ResponsePayloadModel)returnType;
            assert (payloadModel.getEntityField().isPresent());
            String entityFieldName = payloadModel.getEntityField().get().getName();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put(entityFieldName, entityData);
            if (payloadModel.getTechnicalFields().contains((Object)ResponsePayloadModel.TechnicalField.PAGING_STATE) && resultSet.hasPagingState()) {
                ByteBuffer nextPagingState = BytesValues.toByteBuffer(resultSet.getPagingState());
                response.put(ResponsePayloadModel.TechnicalField.PAGING_STATE.getGraphqlName(), BLOB_COERCING.serialize(nextPagingState));
            }
            return response;
        }
        return entityData;
    }
}

