/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.deployed;

import com.google.common.collect.Lists;
import graphql.execution.DataFetcherResult;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.SourceLocation;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import io.stargate.bridge.grpc.Values;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.common.cql.builder.Literal;
import io.stargate.sgv2.common.cql.builder.QueryBuilder;
import io.stargate.sgv2.common.cql.builder.ValueModifier;
import io.stargate.sgv2.graphql.schema.Uuids;
import io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.deployed.MutationFetcher;
import io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.deployed.MutationPayload;
import io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.deployed.MutationResult;
import io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.deployed.TimestampParser;
import io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.deployed.TypedKeyValue;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.FieldModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.InsertModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.MappingModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.OperationModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ResponsePayloadModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.util.TypeHelper;
import io.stargate.sgv2.graphql.web.resources.StargateGraphqlContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;

public class InsertFetcher
extends MutationFetcher<InsertModel, DataFetcherResult<Object>> {
    public InsertFetcher(InsertModel model, MappingModel mappingModel, Schema.CqlKeyspaceDescribe keyspace) {
        super(model, mappingModel, keyspace);
    }

    @Override
    protected MutationPayload<DataFetcherResult<Object>> getPayload(DataFetchingEnvironment environment, StargateGraphqlContext context) {
        DataFetchingFieldSelectionSet selectionSet = environment.getSelectionSet();
        EntityModel entityModel = ((InsertModel)this.model).getEntity();
        boolean isLwt = ((InsertModel)this.model).ifNotExists();
        String entityPrefixInResponse = ((InsertModel)this.model).getResponsePayload().flatMap(ResponsePayloadModel::getEntityField).map(ResponsePayloadModel.EntityField::getName).orElse(null);
        List<Map<String, Object>> inputs = ((InsertModel)this.model).isList() ? (List<Map<String, Object>>)environment.getArgument(((InsertModel)this.model).getEntityArgumentName()) : Collections.singletonList((Map)environment.getArgument(((InsertModel)this.model).getEntityArgumentName()));
        ArrayList<QueryOuterClass.Query> queries = new ArrayList<QueryOuterClass.Query>();
        ArrayList<List<TypedKeyValue>> primaryKeys = new ArrayList<List<TypedKeyValue>>();
        ArrayList<Map<String, QueryOuterClass.Value>> cqlValuesList = Lists.newArrayListWithCapacity(inputs.size());
        for (Map map : inputs) {
            Map<String, QueryOuterClass.Value> cqlValues = this.buildCqlValues(entityModel, this.keyspace, map);
            Collection modifiers = cqlValues.entrySet().stream().map(e -> ValueModifier.set((String)e.getKey(), (QueryOuterClass.Value)e.getValue())).collect(Collectors.toList());
            Optional<Long> timestamp = TimestampParser.parse(((InsertModel)this.model).getCqlTimestampArgumentName(), environment);
            QueryOuterClass.Query query = this.buildInsertQuery(entityModel, modifiers, timestamp, isLwt);
            List<TypedKeyValue> primaryKey = this.computePrimaryKey(entityModel, modifiers);
            queries.add(query);
            primaryKeys.add(primaryKey);
            cqlValuesList.add(cqlValues);
        }
        Function<List<MutationResult>, DataFetcherResult<Object>> resultBuilder = this.getResultBuilder(selectionSet, entityPrefixInResponse, inputs, cqlValuesList, environment);
        return new MutationPayload<DataFetcherResult<Object>>(queries, primaryKeys, resultBuilder);
    }

    private QueryOuterClass.Query buildInsertQuery(EntityModel entityModel, Collection<ValueModifier> modifiers, Optional<Long> timestamp, boolean isLwt) {
        return new QueryBuilder().insertInto(entityModel.getKeyspaceName(), entityModel.getCqlName()).value(modifiers).ifNotExists(isLwt).ttl((Integer)((InsertModel)this.model).getTtl().orElse(null)).timestamp((Long)timestamp.orElse(null)).parameters(this.buildParameters()).build();
    }

    private List<TypedKeyValue> computePrimaryKey(EntityModel entity, Collection<ValueModifier> modifiers) {
        ArrayList<TypedKeyValue> result = new ArrayList<TypedKeyValue>();
        for (FieldModel field : entity.getPrimaryKey()) {
            modifiers.stream().filter(m3 -> field.getCqlName().equals(m3.target().columnName()) && m3.target().mapKey() == null).map(m3 -> ((Literal)m3.value()).get()).findFirst().ifPresent(v -> result.add(new TypedKeyValue(field.getCqlName(), field.getCqlType(), (QueryOuterClass.Value)v)));
        }
        return result;
    }

    private Function<List<MutationResult>, DataFetcherResult<Object>> getResultBuilder(DataFetchingFieldSelectionSet selectionSet, String entityPrefixInResponse, List<Map<String, Object>> inputs, List<Map<String, QueryOuterClass.Value>> cqlValuesList, DataFetchingEnvironment environment) {
        return queryResults -> {
            DataFetcherResult.Builder result = DataFetcherResult.newResult();
            ArrayList<Object> data = new ArrayList<Object>();
            int i = 0;
            for (MutationResult queryResult : queryResults) {
                if (queryResult instanceof MutationResult.Failure) {
                    result.error(this.toGraphqlError((MutationResult.Failure)queryResult, this.getInputLocation(i, environment), environment));
                    data.add(null);
                } else if (this.isBooleanReturnType()) {
                    data.add(queryResult instanceof MutationResult.Applied);
                } else if (this.isEntityReturnType()) {
                    data.add(this.buildEntityResponse(queryResult, (Map)inputs.get(i), (Map)cqlValuesList.get(i)));
                } else if (this.isPayloadModelReturnType()) {
                    data.add(this.buildPayloadResponse(queryResult, entityPrefixInResponse, (Map)inputs.get(i), (Map)cqlValuesList.get(i), selectionSet));
                } else {
                    result.error(this.toGraphqlError(new IllegalArgumentException("Unsupported return type: " + ((InsertModel)this.model).getReturnType()), this.getCurrentFieldLocation(environment), environment));
                    data.add(null);
                }
                ++i;
            }
            return result.data(((InsertModel)this.model).isList() ? data : data.get(0)).build();
        };
    }

    private SourceLocation getInputLocation(int inputIndex, DataFetchingEnvironment environment) {
        Argument argument = environment.getField().getArguments().stream().filter(a -> a.getName().equals(((InsertModel)this.model).getEntityArgumentName())).findFirst().orElseThrow(() -> new AssertionError((Object)"Entity argument should be present"));
        if (((InsertModel)this.model).isList()) {
            ArrayValue arrayValue = (ArrayValue)argument.getValue();
            return arrayValue.getValues().get(inputIndex).getSourceLocation();
        }
        return argument.getSourceLocation();
    }

    private Map<String, Object> buildPayloadResponse(MutationResult queryResult, String entityPrefixInResponse, Map<String, Object> input, Map<String, QueryOuterClass.Value> cqlValues, DataFetchingFieldSelectionSet selectionSet) {
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        if (entityPrefixInResponse != null) {
            LinkedHashMap<String, Object> entityInResponse = new LinkedHashMap<String, Object>();
            response.put(entityPrefixInResponse, entityInResponse);
            if (queryResult instanceof MutationResult.Applied) {
                this.copyInputDataToResponse(input, cqlValues, entityInResponse);
            } else if (queryResult instanceof MutationResult.NotApplied) {
                MutationResult.NotApplied notApplied = (MutationResult.NotApplied)queryResult;
                notApplied.getRow().ifPresent(row -> this.copyRowToEntity((QueryOuterClass.Row)row, notApplied.getColumns(), (Map<String, Object>)entityInResponse, ((InsertModel)this.model).getEntity()));
            }
        }
        if (selectionSet.contains(ResponsePayloadModel.TechnicalField.APPLIED.getGraphqlName())) {
            response.put(ResponsePayloadModel.TechnicalField.APPLIED.getGraphqlName(), queryResult instanceof MutationResult.Applied);
        }
        return response;
    }

    private Map<String, Object> buildEntityResponse(MutationResult queryResult, Map<String, Object> input, Map<String, QueryOuterClass.Value> cqlValues) {
        LinkedHashMap<String, Object> entityResponse = new LinkedHashMap<String, Object>();
        if (queryResult instanceof MutationResult.Applied) {
            this.copyInputDataToResponse(input, cqlValues, entityResponse);
        } else if (queryResult instanceof MutationResult.NotApplied) {
            MutationResult.NotApplied notApplied = (MutationResult.NotApplied)queryResult;
            notApplied.getRow().ifPresent(row -> this.copyRowToEntity((QueryOuterClass.Row)row, notApplied.getColumns(), (Map<String, Object>)entityResponse, ((InsertModel)this.model).getEntity()));
        }
        return entityResponse;
    }

    private boolean isBooleanReturnType() {
        OperationModel.ReturnType returnType = ((InsertModel)this.model).getReturnType();
        return returnType == OperationModel.SimpleReturnType.BOOLEAN || returnType instanceof OperationModel.SimpleListReturnType && ((OperationModel.SimpleListReturnType)returnType).getSimpleReturnType().equals(OperationModel.SimpleReturnType.BOOLEAN);
    }

    private boolean isPayloadModelReturnType() {
        return ((InsertModel)this.model).getResponsePayload().flatMap(ResponsePayloadModel::getEntityField).isPresent();
    }

    private boolean isEntityReturnType() {
        return ((InsertModel)this.model).getReturnType() instanceof OperationModel.EntityReturnType || ((InsertModel)this.model).getReturnType() instanceof OperationModel.EntityListReturnType;
    }

    private Map<String, QueryOuterClass.Value> buildCqlValues(EntityModel entityModel, Schema.CqlKeyspaceDescribe keyspace, Map<String, Object> input) {
        HashMap<String, QueryOuterClass.Value> values = new HashMap<String, QueryOuterClass.Value>();
        for (FieldModel column : entityModel.getAllColumns()) {
            QueryOuterClass.Value cqlValue;
            String graphqlName = column.getGraphqlName();
            if (input.containsKey(graphqlName)) {
                Object graphqlValue = input.get(graphqlName);
                cqlValue = this.toCqlValue(graphqlValue, column.getCqlType(), keyspace);
            } else {
                if (!column.isPrimaryKey()) continue;
                if (TypeHelper.mapsToUuid(column.getGraphqlType())) {
                    cqlValue = this.generateUuid(column.getCqlType());
                } else {
                    throw new IllegalArgumentException("Missing value for field " + graphqlName);
                }
            }
            values.put(column.getCqlName(), cqlValue);
        }
        return values;
    }

    private QueryOuterClass.Value generateUuid(QueryOuterClass.TypeSpec cqlType) {
        if (cqlType.getBasic() == QueryOuterClass.TypeSpec.Basic.UUID) {
            return Values.of(UUID.randomUUID());
        }
        if (cqlType.getBasic() == QueryOuterClass.TypeSpec.Basic.TIMEUUID) {
            return Values.of(Uuids.timeBased());
        }
        throw new AssertionError((Object)("This shouldn't get called for CQL type " + cqlType));
    }

    private void copyInputDataToResponse(Map<String, Object> input, Map<String, QueryOuterClass.Value> cqlValues, Map<String, Object> entityData) {
        for (FieldModel column : ((InsertModel)this.model).getEntity().getAllColumns()) {
            Object graphqlValue;
            String graphqlName = column.getGraphqlName();
            if (input.containsKey(graphqlName)) {
                graphqlValue = input.get(graphqlName);
            } else {
                if (!column.isPrimaryKey()) continue;
                QueryOuterClass.Value cqlValue = cqlValues.get(column.getCqlName());
                graphqlValue = Values.uuid(cqlValue).toString();
            }
            entityData.put(graphqlName, graphqlValue);
        }
    }
}

