/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.deployed;

import graphql.schema.DataFetchingEnvironment;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.common.cql.builder.BuiltCondition;
import io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.deployed.DeployedFetcher;
import io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.deployed.FederatedEntity;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.MappingModel;
import io.stargate.sgv2.graphql.web.resources.StargateGraphqlContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FederatedEntityFetcher
extends DeployedFetcher<List<FederatedEntity>> {
    private final MappingModel mappingModel;

    public FederatedEntityFetcher(MappingModel mappingModel, Schema.CqlKeyspaceDescribe keyspace) {
        super(mappingModel, keyspace);
        this.mappingModel = mappingModel;
    }

    @Override
    protected List<FederatedEntity> get(DataFetchingEnvironment environment, StargateGraphqlContext context) {
        ArrayList<FederatedEntity> result = new ArrayList<FederatedEntity>();
        for (Map representation : (List)environment.getArgument("representations")) {
            result.add(this.getEntity(representation, context));
        }
        return result;
    }

    private FederatedEntity getEntity(Map<String, Object> representation, StargateGraphqlContext context) {
        Object rawTypeName = representation.get("__typename");
        if (!(rawTypeName instanceof String)) {
            throw new IllegalArgumentException("Entity representations must contain a '__typename' string field");
        }
        String entityName = (String)rawTypeName;
        EntityModel entityModel = this.mappingModel.getEntities().get(entityName);
        if (entityModel == null) {
            throw new IllegalArgumentException(String.format("Unknown entity type %s", entityName));
        }
        List<BuiltCondition> whereConditions = this.bindWhere(entityModel.getPrimaryKeyWhereConditions(), representation::containsKey, representation::get, entityModel::validateNoFiltering, this.keyspace);
        QueryOuterClass.ResultSet resultSet = this.query(entityModel, whereConditions, Optional.empty(), DEFAULT_PARAMETERS, context);
        Map<String, Object> entity = this.toSingleEntity(resultSet, entityModel);
        return FederatedEntity.wrap(entityModel, entity);
    }
}

