/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.schema.graphqlfirst.fetchers.deployed;

import com.google.common.collect.Maps;
import graphql.Scalars;
import graphql.language.ListType;
import graphql.language.Type;
import graphql.schema.GraphQLScalarType;
import io.stargate.bridge.grpc.CqlDuration;
import io.stargate.bridge.grpc.TypeSpecs;
import io.stargate.bridge.grpc.Values;
import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.bridge.proto.Schema;
import io.stargate.sgv2.common.cql.builder.BuiltCondition;
import io.stargate.sgv2.common.cql.builder.QueryBuilder;
import io.stargate.sgv2.common.grpc.proto.Rows;
import io.stargate.sgv2.graphql.schema.CassandraFetcher;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.ConditionModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.EntityModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.FieldModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.processor.MappingModel;
import io.stargate.sgv2.graphql.schema.graphqlfirst.util.TypeHelper;
import io.stargate.sgv2.graphql.schema.scalars.CqlScalar;
import io.stargate.sgv2.graphql.web.resources.StargateGraphqlContext;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

abstract class DeployedFetcher<ResultT>
extends CassandraFetcher<ResultT> {
    protected final MappingModel mappingModel;
    protected final Schema.CqlKeyspaceDescribe keyspace;

    public DeployedFetcher(MappingModel mappingModel, Schema.CqlKeyspaceDescribe keyspace) {
        this.mappingModel = mappingModel;
        this.keyspace = keyspace;
    }

    protected QueryOuterClass.Value toCqlValue(Object graphqlValue, QueryOuterClass.TypeSpec cqlType, Schema.CqlKeyspaceDescribe keyspace) {
        if (graphqlValue == null) {
            return Values.NULL;
        }
        switch (cqlType.getSpecCase()) {
            case LIST: {
                return this.toCqlCollection(graphqlValue, cqlType.getList().getElement(), keyspace);
            }
            case SET: {
                return this.toCqlCollection(graphqlValue, cqlType.getSet().getElement(), keyspace);
            }
            case UDT: {
                return this.toCqlUdtValue(graphqlValue, cqlType.getUdt(), keyspace);
            }
            case BASIC: {
                QueryOuterClass.TypeSpec.Basic basic = cqlType.getBasic();
                switch (basic) {
                    case ASCII: 
                    case VARCHAR: {
                        return Values.of(this.toCqlLiteral(graphqlValue, String.class, Scalars.GraphQLString));
                    }
                    case INET: {
                        return Values.of(this.toCqlLiteral(graphqlValue, InetAddress.class, CqlScalar.INET.getGraphqlType()));
                    }
                    case BIGINT: 
                    case COUNTER: {
                        return Values.of(this.toCqlLiteral(graphqlValue, Long.class, CqlScalar.BIGINT.getGraphqlType()));
                    }
                    case BLOB: {
                        return Values.of(this.toCqlLiteral(graphqlValue, ByteBuffer.class, CqlScalar.BLOB.getGraphqlType()));
                    }
                    case BOOLEAN: {
                        return Values.of(this.toCqlLiteral(graphqlValue, Boolean.class, Scalars.GraphQLBoolean));
                    }
                    case DECIMAL: {
                        return Values.of(this.toCqlLiteral(graphqlValue, BigDecimal.class, CqlScalar.DECIMAL.getGraphqlType()));
                    }
                    case DOUBLE: {
                        return Values.of(this.toCqlLiteral(graphqlValue, Double.class, Scalars.GraphQLFloat));
                    }
                    case FLOAT: {
                        return Values.of(this.toCqlLiteral(graphqlValue, Float.class, CqlScalar.FLOAT.getGraphqlType()).floatValue());
                    }
                    case INT: {
                        return Values.of(this.toCqlLiteral(graphqlValue, Integer.class, Scalars.GraphQLInt).intValue());
                    }
                    case TIMESTAMP: {
                        return Values.of(this.toCqlLiteral(graphqlValue, Instant.class, CqlScalar.TIMESTAMP.getGraphqlType()).toEpochMilli());
                    }
                    case UUID: {
                        return Values.of(this.toCqlLiteral(graphqlValue, UUID.class, CqlScalar.UUID.getGraphqlType()));
                    }
                    case TIMEUUID: {
                        return Values.of(this.toCqlLiteral(graphqlValue, UUID.class, CqlScalar.TIMEUUID.getGraphqlType()));
                    }
                    case VARINT: {
                        return Values.of(this.toCqlLiteral(graphqlValue, BigInteger.class, CqlScalar.VARINT.getGraphqlType()));
                    }
                    case DATE: {
                        return Values.of(this.toCqlLiteral(graphqlValue, LocalDate.class, CqlScalar.DATE.getGraphqlType()));
                    }
                    case TIME: {
                        return Values.of(this.toCqlLiteral(graphqlValue, LocalTime.class, CqlScalar.TIME.getGraphqlType()));
                    }
                    case SMALLINT: {
                        return Values.of(this.toCqlLiteral(graphqlValue, Short.class, CqlScalar.SMALLINT.getGraphqlType()));
                    }
                    case TINYINT: {
                        return Values.of(this.toCqlLiteral(graphqlValue, Byte.class, CqlScalar.TINYINT.getGraphqlType()));
                    }
                    case DURATION: {
                        return Values.of(this.toCqlLiteral(graphqlValue, CqlDuration.class, CqlScalar.DURATION.getGraphqlType()));
                    }
                }
                throw new AssertionError((Object)("Unsupported primitive type " + cqlType));
            }
        }
        throw new AssertionError((Object)String.format("Unsupported CQL type %s, this mapping should have failed at deployment time", cqlType));
    }

    private <T> T toCqlLiteral(Object value, Class<T> targetClass, GraphQLScalarType scalar) {
        if (targetClass.isInstance(value)) {
            return targetClass.cast(value);
        }
        return (T)scalar.getCoercing().parseValue(value);
    }

    private QueryOuterClass.Value toCqlCollection(Object graphqlValue, QueryOuterClass.TypeSpec cqlElementType, Schema.CqlKeyspaceDescribe keyspace) {
        Collection graphQLCollection = (Collection)graphqlValue;
        QueryOuterClass.Value[] cqlCollection = new QueryOuterClass.Value[graphQLCollection.size()];
        int i = 0;
        for (Object element : graphQLCollection) {
            cqlCollection[i] = this.toCqlValue(element, cqlElementType, keyspace);
            ++i;
        }
        return Values.of(cqlCollection);
    }

    private QueryOuterClass.Value toCqlUdtValue(Object graphqlValue, QueryOuterClass.TypeSpec.Udt cqlType, Schema.CqlKeyspaceDescribe keyspace) {
        String udtName = cqlType.getName();
        EntityModel udtModel = this.mappingModel.getEntities().get(udtName);
        if (udtModel == null) {
            throw new IllegalStateException(String.format("UDT '%s' is not mapped to a GraphQL type", udtName));
        }
        QueryOuterClass.TypeSpec.Udt udt = keyspace.getTypesList().stream().filter(t -> udtName.equals(t.getName())).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Unknown UDT %s. It looks like it was dropped manually after the deployment.", udtName)));
        QueryOuterClass.UdtValue.Builder udtValue = QueryOuterClass.UdtValue.newBuilder();
        Map graphqlObject = (Map)graphqlValue;
        for (FieldModel field : udtModel.getRegularColumns()) {
            if (!graphqlObject.containsKey(field.getGraphqlName())) continue;
            QueryOuterClass.TypeSpec fieldCqlType = udt.getFieldsMap().get(field.getCqlName());
            if (fieldCqlType == null) {
                throw new IllegalStateException(String.format("Unknown field %s in UDT %s. It looks like it was altered manually after the deployment.", field.getCqlName(), udtName));
            }
            Object fieldGraphqlValue = graphqlObject.get(field.getGraphqlName());
            QueryOuterClass.Value fieldCqlValue = this.toCqlValue(fieldGraphqlValue, fieldCqlType, keyspace);
            udtValue.putFields(field.getCqlName(), fieldCqlValue);
        }
        return QueryOuterClass.Value.newBuilder().setUdt(udtValue).build();
    }

    protected Object toGraphqlValue(QueryOuterClass.Value cqlValue, QueryOuterClass.TypeSpec cqlType, Type<?> graphqlType) {
        if (cqlValue.equals(Values.NULL)) {
            return null;
        }
        switch (cqlType.getSpecCase()) {
            case LIST: {
                return this.toGraphqlList(cqlValue.getCollection(), cqlType.getList().getElement(), graphqlType);
            }
            case SET: {
                return this.toGraphqlList(cqlValue.getCollection(), cqlType.getSet().getElement(), graphqlType);
            }
            case UDT: {
                return this.toGraphqlUdtValue(cqlValue.getUdt(), cqlType);
            }
            case BASIC: {
                switch (cqlType.getBasic()) {
                    case ASCII: 
                    case VARCHAR: {
                        return Values.string(cqlValue);
                    }
                    case INET: {
                        return Values.inet(cqlValue);
                    }
                    case BIGINT: 
                    case COUNTER: {
                        return Values.bigint(cqlValue);
                    }
                    case BLOB: {
                        return Values.byteBuffer(cqlValue);
                    }
                    case BOOLEAN: {
                        return Values.bool(cqlValue);
                    }
                    case DECIMAL: {
                        return Values.decimal(cqlValue);
                    }
                    case DOUBLE: {
                        return Values.double_(cqlValue);
                    }
                    case FLOAT: {
                        return Float.valueOf(Values.float_(cqlValue));
                    }
                    case INT: {
                        return Values.int_(cqlValue);
                    }
                    case TIMESTAMP: {
                        return Instant.ofEpochMilli(Values.bigint(cqlValue));
                    }
                    case UUID: {
                        UUID uuid = Values.uuid(cqlValue);
                        return TypeHelper.isGraphqlId(graphqlType) ? uuid.toString() : uuid;
                    }
                    case TIMEUUID: {
                        return Values.uuid(cqlValue);
                    }
                    case VARINT: {
                        return Values.varint(cqlValue);
                    }
                    case DATE: {
                        return Values.date(cqlValue);
                    }
                    case TIME: {
                        return Values.time(cqlValue);
                    }
                    case SMALLINT: {
                        return Values.smallint(cqlValue);
                    }
                    case TINYINT: {
                        return Values.tinyint(cqlValue);
                    }
                    case DURATION: {
                        return Values.duration(cqlValue);
                    }
                }
                throw new AssertionError((Object)("Unhandled basic type " + cqlType.getBasic()));
            }
        }
        throw new AssertionError((Object)String.format("Unsupported CQL type %s, this mapping should have failed at deployment time", cqlType));
    }

    private Object toGraphqlList(QueryOuterClass.Collection cqlValues, QueryOuterClass.TypeSpec cqlElementType, Type<?> graphqlType) {
        assert (graphqlType instanceof ListType);
        Type graphqlElementType = ((ListType)graphqlType).getType();
        return cqlValues.getElementsList().stream().map(e -> this.toGraphqlValue((QueryOuterClass.Value)e, cqlElementType, graphqlElementType)).collect(Collectors.toList());
    }

    private Object toGraphqlUdtValue(QueryOuterClass.UdtValue cqlValue, QueryOuterClass.TypeSpec cqlType) {
        String udtName = cqlType.getUdt().getName();
        EntityModel udtModel = this.mappingModel.getEntities().get(udtName);
        if (udtModel == null) {
            throw new IllegalStateException(String.format("UDT '%s' is not mapped to a GraphQL type", udtName));
        }
        LinkedHashMap<String, Object> result = Maps.newLinkedHashMapWithExpectedSize(udtModel.getRegularColumns().size());
        for (FieldModel field : udtModel.getRegularColumns()) {
            QueryOuterClass.Value cqlFieldValue = cqlValue.getFieldsMap().get(field.getCqlName());
            result.put(field.getGraphqlName(), this.toGraphqlValue(cqlFieldValue, field.getCqlType(), field.getGraphqlType()));
        }
        return result;
    }

    protected QueryOuterClass.ResultSet query(EntityModel entity, List<BuiltCondition> whereConditions, Optional<Integer> limit, QueryOuterClass.QueryParameters parameters, StargateGraphqlContext context) {
        QueryOuterClass.Query query = new QueryBuilder().select().column((String[])entity.getAllColumns().stream().map(FieldModel::getCqlName).toArray(String[]::new)).from(entity.getKeyspaceName(), entity.getCqlName()).where(whereConditions).limit((Integer)limit.orElse(null)).parameters(parameters).build();
        return context.getBridge().executeQuery(query).getResultSet();
    }

    protected Map<String, Object> toSingleEntity(QueryOuterClass.ResultSet resultSet, EntityModel entity) {
        return resultSet.getRowsCount() == 0 ? null : this.toEntity(resultSet.getRows(0), resultSet.getColumnsList(), entity);
    }

    protected List<Map<String, Object>> toEntities(QueryOuterClass.ResultSet resultSet, EntityModel entity) {
        List<QueryOuterClass.ColumnSpec> columns = resultSet.getColumnsList();
        return resultSet.getRowsList().stream().map(row -> this.toEntity((QueryOuterClass.Row)row, columns, entity)).collect(Collectors.toList());
    }

    private Map<String, Object> toEntity(QueryOuterClass.Row row, List<QueryOuterClass.ColumnSpec> columns, EntityModel entity) {
        HashMap<String, Object> singleResult = new HashMap<String, Object>();
        for (FieldModel field : entity.getAllColumns()) {
            QueryOuterClass.Value cqlValue = Rows.getValue(row, field.getCqlName(), columns);
            singleResult.put(field.getGraphqlName(), this.toGraphqlValue(cqlValue, field.getCqlType(), field.getGraphqlType()));
        }
        return singleResult;
    }

    protected void copyRowToEntity(QueryOuterClass.Row row, List<QueryOuterClass.ColumnSpec> columns, Map<String, Object> entityData, EntityModel entity) {
        for (FieldModel field : entity.getAllColumns()) {
            if (columns.stream().noneMatch(c -> c.getName().equals(field.getCqlName()))) continue;
            QueryOuterClass.Value cqlValue = Rows.getValue(row, field.getCqlName(), columns);
            entityData.put(field.getGraphqlName(), this.toGraphqlValue(cqlValue, field.getCqlType(), field.getGraphqlType()));
        }
    }

    protected List<BuiltCondition> bindWhere(List<ConditionModel> conditions, Predicate<String> hasArgument, Function<String, Object> getArgument, Function<List<ConditionModel>, Optional<String>> validator, Schema.CqlKeyspaceDescribe keyspace) {
        ArrayList<BuiltCondition> result = new ArrayList<BuiltCondition>();
        List<ConditionModel> activeConditions = this.bind(conditions, hasArgument, getArgument, keyspace, result);
        validator.apply(activeConditions).ifPresent(message -> {
            throw new IllegalArgumentException("Invalid arguments: " + message);
        });
        return result;
    }

    protected List<BuiltCondition> bindIf(List<ConditionModel> conditions, Predicate<String> hasArgument, Function<String, Object> getArgument, Schema.CqlKeyspaceDescribe keyspace) {
        ArrayList<BuiltCondition> result = new ArrayList<BuiltCondition>();
        this.bind(conditions, hasArgument, getArgument, keyspace, result);
        return result;
    }

    private <T extends ConditionModel> List<T> bind(List<T> conditions, Predicate<String> hasArgument, Function<String, Object> getArgument, Schema.CqlKeyspaceDescribe keyspace, List<BuiltCondition> result) {
        ArrayList<ConditionModel> activeConditions = new ArrayList<ConditionModel>();
        for (ConditionModel condition : conditions) {
            QueryOuterClass.TypeSpec cqlType;
            FieldModel field = condition.getField();
            if (!hasArgument.test(condition.getArgumentName())) continue;
            activeConditions.add(condition);
            Object graphqlValue = getArgument.apply(condition.getArgumentName());
            block0 : switch (condition.getPredicate()) {
                case IN: {
                    cqlType = TypeSpecs.list(field.getCqlType());
                    break;
                }
                case CONTAINS: {
                    switch (field.getCqlType().getSpecCase()) {
                        case LIST: {
                            cqlType = field.getCqlType().getList().getElement();
                            break block0;
                        }
                        case SET: {
                            cqlType = field.getCqlType().getSet().getElement();
                            break block0;
                        }
                    }
                    throw new AssertionError((Object)("Unexpected type for CONTAINS operator " + field.getCqlType()));
                }
                default: {
                    cqlType = field.getCqlType();
                }
            }
            QueryOuterClass.Value cqlValue = this.toCqlValue(graphqlValue, cqlType, keyspace);
            result.add(condition.build(cqlValue));
        }
        return activeConditions;
    }
}

