/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.graphql.persistence.graphqlfirst;

import io.stargate.sgv2.graphql.schema.Uuids;
import io.stargate.sgv2.graphql.web.resources.ResourcePaths;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.UUID;

public class SchemaSource {
    private final String keyspace;
    private final UUID version;
    private final String contents;

    public SchemaSource(String keyspace, UUID version, String contents) {
        this.keyspace = keyspace;
        this.version = version;
        this.contents = contents;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public UUID getVersion() {
        return this.version;
    }

    public ZonedDateTime getDeployDate() {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(Uuids.unixTimestamp(this.version)), ZoneId.systemDefault());
    }

    public String getContents() {
        return this.contents;
    }

    public String getContentsUri() {
        return String.format("%s/keyspace/%s.graphql?version=%s", ResourcePaths.FILES_RELATIVE_TO_ADMIN, this.keyspace, this.version);
    }

    public String toString() {
        return "SchemaSource{keyspace='" + this.keyspace + '\'' + ", version=" + this.version + ", contents='" + this.contents + '\'' + '}';
    }
}

