/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.common.futures;

import io.stargate.sgv2.common.futures.UncheckedExecutionException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public class Futures {
    public static <T> T getUninterruptibly(CompletionStage<T> stage) {
        boolean interrupted = false;
        while (true) {
            try {
                T t = stage.toCompletableFuture().get();
                return t;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new UncheckedExecutionException(cause);
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T> CompletableFuture<T> failedFuture(Exception e) {
        CompletableFuture f = new CompletableFuture();
        f.completeExceptionally(e);
        return f;
    }

    public static <T> CompletionStage<List<T>> sequence(List<CompletionStage<T>> futures) {
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> futures.stream().map(f -> f.toCompletableFuture().join()).collect(Collectors.toList()));
    }
}

