/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.common.cql.builder;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.stargate.sgv2.common.cql.builder.Term;
import io.stargate.sgv2.common.cql.builder.ValueModifier;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ValueModifier", generator="Immutables")
@Immutable
final class ImmutableValueModifier
implements ValueModifier {
    private final ValueModifier.Target target;
    private final ValueModifier.Operation operation;
    private final Term value;

    private ImmutableValueModifier(ValueModifier.Target target, ValueModifier.Operation operation, Term value) {
        this.target = target;
        this.operation = operation;
        this.value = value;
    }

    @Override
    public ValueModifier.Target target() {
        return this.target;
    }

    @Override
    public ValueModifier.Operation operation() {
        return this.operation;
    }

    @Override
    public Term value() {
        return this.value;
    }

    public final ImmutableValueModifier withTarget(ValueModifier.Target value) {
        if (this.target == value) {
            return this;
        }
        ValueModifier.Target newValue = Objects.requireNonNull(value, "target");
        return new ImmutableValueModifier(newValue, this.operation, this.value);
    }

    public final ImmutableValueModifier withOperation(ValueModifier.Operation value) {
        if (this.operation == value) {
            return this;
        }
        ValueModifier.Operation newValue = Objects.requireNonNull(value, "operation");
        if (this.operation.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableValueModifier(this.target, newValue, this.value);
    }

    public final ImmutableValueModifier withValue(Term value) {
        if (this.value == value) {
            return this;
        }
        Term newValue = Objects.requireNonNull(value, "value");
        return new ImmutableValueModifier(this.target, this.operation, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValueModifier && this.equalTo((ImmutableValueModifier)another);
    }

    private boolean equalTo(ImmutableValueModifier another) {
        return this.target.equals(another.target) && this.operation.equals((Object)another.operation) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.target.hashCode();
        h2 += (h2 << 5) + this.operation.hashCode();
        h2 += (h2 << 5) + this.value.hashCode();
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ValueModifier").omitNullValues().add("target", this.target).add("operation", (Object)this.operation).add("value", this.value).toString();
    }

    public static ImmutableValueModifier copyOf(ValueModifier instance) {
        if (instance instanceof ImmutableValueModifier) {
            return (ImmutableValueModifier)instance;
        }
        return ImmutableValueModifier.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ValueModifier", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TARGET = 1L;
        private static final long INIT_BIT_OPERATION = 2L;
        private static final long INIT_BIT_VALUE = 4L;
        private long initBits = 7L;
        @Nullable
        private ValueModifier.Target target;
        @Nullable
        private ValueModifier.Operation operation;
        @Nullable
        private Term value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ValueModifier instance) {
            Objects.requireNonNull(instance, "instance");
            this.target(instance.target());
            this.operation(instance.operation());
            this.value(instance.value());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder target(ValueModifier.Target target) {
            this.target = Objects.requireNonNull(target, "target");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder operation(ValueModifier.Operation operation) {
            this.operation = Objects.requireNonNull(operation, "operation");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(Term value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableValueModifier build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableValueModifier(this.target, this.operation, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("target");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("operation");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build ValueModifier, some of required attributes are not set " + attributes;
        }
    }
}

