/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sgv2.common.cql.builder;

import io.stargate.bridge.proto.QueryOuterClass;
import io.stargate.sgv2.common.cql.ColumnUtils;
import io.stargate.sgv2.common.cql.builder.ImmutableBuiltCondition;
import io.stargate.sgv2.common.cql.builder.Marker;
import io.stargate.sgv2.common.cql.builder.Predicate;
import io.stargate.sgv2.common.cql.builder.QueryBuilderImpl;
import io.stargate.sgv2.common.cql.builder.Term;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
@Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE)
public interface BuiltCondition {
    public LHS lhs();

    public Predicate predicate();

    public Term value();

    public static BuiltCondition of(String columnName, Predicate predicate, QueryOuterClass.Value value) {
        return BuiltCondition.of(columnName, predicate, Term.of(value));
    }

    public static BuiltCondition of(String columnName, Predicate predicate, Term value) {
        return BuiltCondition.of(LHS.column(columnName), predicate, value);
    }

    public static BuiltCondition of(LHS lhs, Predicate predicate, QueryOuterClass.Value value) {
        return BuiltCondition.of(lhs, predicate, Term.of(value));
    }

    public static BuiltCondition of(LHS lhs, Predicate predicate, Term value) {
        return ImmutableBuiltCondition.builder().lhs(lhs).predicate(predicate).value(value).build();
    }

    public static abstract class LHS {
        public static LHS column(String columnName) {
            return new ColumnName(columnName);
        }

        public static LHS mapAccess(String columnName, QueryOuterClass.Value key) {
            return new MapElement(columnName, Term.of(key));
        }

        public static LHS columnTuple(String ... columnNames) {
            throw new UnsupportedOperationException();
        }

        public static LHS token(String ... columnNames) {
            throw new UnsupportedOperationException();
        }

        abstract void appendToBuilder(StringBuilder var1, Map<Marker, QueryOuterClass.Value> var2, List<QueryOuterClass.Value> var3);

        public abstract String columnName();

        public Optional<Term> value() {
            return Optional.empty();
        }

        static final class MapElement
        extends LHS {
            private final String columnName;
            private final Term keyValue;

            MapElement(String columnName, Term keyValue) {
                this.columnName = columnName;
                this.keyValue = keyValue;
            }

            @Override
            public String columnName() {
                return this.columnName;
            }

            Term keyValue() {
                return this.keyValue;
            }

            @Override
            public Optional<Term> value() {
                return Optional.of(this.keyValue);
            }

            @Override
            void appendToBuilder(StringBuilder builder, Map<Marker, QueryOuterClass.Value> markers, List<QueryOuterClass.Value> boundValues) {
                builder.append(ColumnUtils.maybeQuote(this.columnName)).append('[').append(QueryBuilderImpl.formatValue(this.keyValue, markers, boundValues)).append(']');
            }

            public boolean equals(Object other) {
                if (other == this) {
                    return true;
                }
                if (other instanceof MapElement) {
                    MapElement that = (MapElement)other;
                    return Objects.equals(this.columnName, that.columnName) && Objects.equals(this.keyValue, that.keyValue);
                }
                return false;
            }

            public int hashCode() {
                return Objects.hash(this.columnName, this.keyValue);
            }
        }

        static final class ColumnName
        extends LHS {
            private final String columnName;

            private ColumnName(String columnName) {
                this.columnName = columnName;
            }

            @Override
            public String columnName() {
                return this.columnName;
            }

            @Override
            void appendToBuilder(StringBuilder builder, Map<Marker, QueryOuterClass.Value> markers, List<QueryOuterClass.Value> boundValues) {
                builder.append(ColumnUtils.maybeQuote(this.columnName));
            }

            public boolean equals(Object other) {
                if (other == this) {
                    return true;
                }
                if (other instanceof ColumnName) {
                    ColumnName that = (ColumnName)other;
                    return Objects.equals(this.columnName, that.columnName);
                }
                return false;
            }

            public int hashCode() {
                return Objects.hash(this.columnName);
            }
        }
    }
}

